/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface SlotProvider {
    public static final SlotProvider ALL = inv -> IntStream.range(0, inv.f_35974_.size()).mapToObj(i -> Slot.invSlot(inv, i)).iterator();
    public static final SlotProvider OFF_HAND = inv -> IntStream.range(0, inv.f_35976_.size()).mapToObj(i -> Slot.offHandSlot(inv, i)).iterator();
    public static final SlotProvider MAIN_HAND = inv -> List.of(Slot.invSlot(inv, inv.f_35977_)).iterator();

    public Iterator<Slot> getSlots(Inventory var1);

    public static SlotProvider hand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return MAIN_HAND;
        }
        return OFF_HAND;
    }

    public static SlotProvider single(int slot) {
        return inv -> List.of(Slot.invSlot(inv, slot)).iterator();
    }

    public static interface Slot {
        public ItemStack getStack();

        public boolean add(ItemStack var1, Inventory var2, Player var3);

        public static Slot invSlot(final Inventory inv, final int slot) {
            return new Slot(){

                @Override
                public ItemStack getStack() {
                    return inv.m_8020_(slot);
                }

                @Override
                public boolean add(ItemStack toAdd, Inventory inv2, Player player) {
                    ItemStack current = this.getStack();
                    if (!current.m_41619_() && !inv2.m_36014_(current, toAdd)) {
                        return false;
                    }
                    if (toAdd.m_41619_()) {
                        return false;
                    }
                    try {
                        int originalCount;
                        do {
                            originalCount = toAdd.m_41613_();
                            toAdd.m_41764_(inv2.m_36047_(slot, toAdd));
                        } while (!toAdd.m_41619_() && toAdd.m_41613_() < originalCount);
                        return toAdd.m_41613_() < originalCount;
                    }
                    catch (Throwable var6) {
                        CrashReport crashReport = CrashReport.m_127521_((Throwable)var6, (String)"Adding item to inventory");
                        CrashReportCategory crashReportCategory = crashReport.m_127514_("Item being added");
                        crashReportCategory.m_128159_("Item ID", (Object)Item.m_41393_((Item)toAdd.m_41720_()));
                        crashReportCategory.m_128159_("Item data", (Object)toAdd.m_41773_());
                        crashReportCategory.m_128165_("Item name", () -> toAdd.m_41786_().getString());
                        throw new ReportedException(crashReport);
                    }
                }
            };
        }

        public static Slot offHandSlot(final Inventory inv, final int offHandSlot) {
            return new Slot(){

                @Override
                public ItemStack getStack() {
                    return (ItemStack)inv.f_35976_.get(offHandSlot);
                }

                @Override
                public boolean add(ItemStack stack, Inventory inv2, Player player) {
                    if (stack.m_41619_()) {
                        return false;
                    }
                    try {
                        int originalCount;
                        do {
                            originalCount = stack.m_41613_();
                            this.addResourceOffHand(stack, inv2);
                        } while (!stack.m_41619_() && stack.m_41613_() < originalCount);
                        if (stack.m_41613_() == originalCount && player.m_150110_().f_35937_) {
                            stack.m_41764_(0);
                            return true;
                        }
                        return stack.m_41613_() < originalCount;
                    }
                    catch (Throwable var6) {
                        CrashReport crashReport = CrashReport.m_127521_((Throwable)var6, (String)"Adding item to inventory");
                        CrashReportCategory crashReportCategory = crashReport.m_127514_("Item being added");
                        crashReportCategory.m_128159_("Item ID", (Object)Item.m_41393_((Item)stack.m_41720_()));
                        crashReportCategory.m_128159_("Item data", (Object)stack.m_41773_());
                        crashReportCategory.m_128165_("Item name", () -> stack.m_41786_().getString());
                        throw new ReportedException(crashReport);
                    }
                }

                private void addResourceOffHand(ItemStack toAdd, Inventory inv2) {
                    Item item = toAdd.m_41720_();
                    NonNullList offHand = inv2.f_35976_;
                    for (int offSlot = 0; offSlot < offHand.size(); ++offSlot) {
                        int stackCount = toAdd.m_41613_();
                        ItemStack handStack = (ItemStack)offHand.get(offSlot);
                        if (handStack.m_41619_()) {
                            handStack = new ItemStack((ItemLike)item, 0);
                            if (toAdd.m_41782_()) {
                                handStack.m_41751_(toAdd.m_41783_().m_6426_());
                            }
                            offHand.set(offSlot, (Object)handStack);
                        } else if (!inv2.m_36014_(handStack, toAdd)) continue;
                        int addedCount = stackCount;
                        if (addedCount > handStack.m_41741_() - handStack.m_41613_()) {
                            addedCount = handStack.m_41741_() - handStack.m_41613_();
                        }
                        if (addedCount > inv2.m_6893_() - handStack.m_41613_()) {
                            addedCount = inv2.m_6893_() - handStack.m_41613_();
                        }
                        if (addedCount == 0) continue;
                        handStack.m_41769_(addedCount);
                        handStack.m_41754_(5);
                        toAdd.m_41764_(stackCount -= addedCount);
                    }
                }
            };
        }
    }
}

