/*
 * Decompiled with CFR 0.152.
 */
package net.darkblade.mini_pekka.server.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;

public class SimpleAabbMeleeGoal<E extends PathfinderMob>
extends Goal {
    private final E mob;
    private final double CHASE_SPEED;
    private final double ATTACK_RANGE;
    private final boolean REQUIRE_LOS;
    private final int DURATION_TICKS;
    private final int[] DAMAGE_FRAMES;
    private final int COOLDOWN_BASE_TICKS;
    private final AttackHitbox HITBOX;
    private final AttackAnimBridge animBridge;
    private boolean active = false;
    private int tick = 0;
    private int cooldown = 0;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = true;
    private static final int RECALC_BASE_MIN = 2;
    private static final int RECALC_BASE_MAX = 4;
    private static final int FAILED_PENALTY_MAX = 20;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_AABB = false;

    public SimpleAabbMeleeGoal(E mob, double attackRangeEdge, double chaseSpeed, boolean requireLOS, int durationTicks, int[] damageFrames, int cooldownBase, AttackHitbox hitbox, AttackAnimBridge animBridge) {
        this.mob = mob;
        this.ATTACK_RANGE = Math.max(0.0, attackRangeEdge);
        this.CHASE_SPEED = chaseSpeed;
        this.REQUIRE_LOS = requireLOS;
        this.DURATION_TICKS = durationTicks;
        this.DAMAGE_FRAMES = damageFrames;
        this.COOLDOWN_BASE_TICKS = cooldownBase;
        this.HITBOX = hitbox;
        this.animBridge = animBridge;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity t = this.mob.m_5448_();
        if (t == null || !t.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)t, 0);
        if (this.path != null) {
            return true;
        }
        return this.isInAttackRangeEdgeXZ(t);
    }

    public boolean m_8045_() {
        LivingEntity t = this.mob.m_5448_();
        return t != null && t.m_6084_();
    }

    public void m_8056_() {
        LivingEntity t = this.mob.m_5448_();
        if (t != null && this.path != null) {
            this.mob.m_21573_().m_26536_(this.path, this.CHASE_SPEED);
        }
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        this.setAttackActive(false);
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean hasLOS;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            this.setAttackActive(false);
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        double d3 = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean inEdgeRange = this.isInAttackRangeEdgeXZ(target);
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        boolean bl = hasLOS = !this.REQUIRE_LOS || this.mob.m_21574_().m_148306_((Entity)target);
        if (this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
            this.pathedTargetX = target.m_20185_();
            this.pathedTargetY = target.m_20186_();
            this.pathedTargetZ = target.m_20189_();
            this.ticksUntilNextPathRecalculation = 2 + this.mob.m_217043_().m_188503_(3);
            if (this.canPenalize) {
                Node end;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((end = this.mob.m_21573_().m_26570_().m_77395_()) != null && target.m_20275_((double)end.f_77271_, (double)end.f_77272_, (double)end.f_77273_) < 1.0 ? 0 : Math.min(this.failedPathFindingPenalty + 10, 20)) : Math.min(this.failedPathFindingPenalty + 10, 20);
            }
            if (d3 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d3 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)target, this.CHASE_SPEED)) {
                this.mob.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.CHASE_SPEED);
                this.ticksUntilNextPathRecalculation += 8;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
        if ((this.mob.m_21573_().m_26571_() || this.mob.m_21573_().m_26570_() == null) && !inEdgeRange) {
            this.mob.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.CHASE_SPEED);
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        if (!this.active) {
            boolean canStartAttack;
            boolean bl2 = canStartAttack = !this.REQUIRE_LOS || hasLOS;
            if (inEdgeRange && this.ticksUntilNextAttack <= 0 && canStartAttack) {
                this.startAttack();
                this.resetAttackCooldown();
            }
        } else {
            this.updateAttackFrames();
        }
        if (this.active && !inEdgeRange) {
            this.mob.m_21573_().m_5624_((Entity)target, this.CHASE_SPEED);
        }
    }

    private boolean isInAttackRangeEdgeXZ(LivingEntity target) {
        double sumR;
        double dz;
        double dx = target.m_20185_() - this.mob.m_20185_();
        double distXZ = Math.sqrt(dx * dx + (dz = target.m_20189_() - this.mob.m_20189_()) * dz);
        double edge = Math.max(0.0, distXZ - (sumR = 0.5 * (double)(this.mob.m_20205_() + target.m_20205_())));
        return edge <= this.ATTACK_RANGE;
    }

    private double[] edgeDebug(LivingEntity target) {
        double dx = target.m_20185_() - this.mob.m_20185_();
        double dz = target.m_20189_() - this.mob.m_20189_();
        double distXZ = Math.sqrt(dx * dx + dz * dz);
        double sumR = 0.5 * (double)(this.mob.m_20205_() + target.m_20205_());
        double edge = Math.max(0.0, distXZ - sumR);
        double thr = this.ATTACK_RANGE;
        return new double[]{distXZ, sumR, edge, thr};
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    private void startAttack() {
        this.tick = 0;
        this.setAttackActive(true);
    }

    private void endAttack() {
        this.setAttackActive(false);
        this.cooldown = this.COOLDOWN_BASE_TICKS;
    }

    private void setAttackActive(boolean v) {
        if (this.active == v) {
            return;
        }
        this.active = v;
        this.animBridge.setAttacking(v);
    }

    private void updateAttackFrames() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        ++this.tick;
        for (int f : this.DAMAGE_FRAMES) {
            if (this.tick != f) continue;
            AABB box = this.buildAABBFromHeadYaw(this.HITBOX);
            this.applyDamageInBox(box);
            break;
        }
        if (this.tick >= this.DURATION_TICKS) {
            this.endAttack();
        }
    }

    private AABB buildAABBFromHeadYaw(AttackHitbox hb) {
        float yawRad = this.mob.m_6080_() * ((float)Math.PI / 180);
        double dirX = -Mth.m_14031_((float)yawRad);
        double dirZ = Mth.m_14089_((float)yawRad);
        double rightX = -dirZ;
        double rightZ = dirX;
        double cx = this.mob.m_20185_() + dirX * hb.forward + rightX * hb.lateral;
        double cz = this.mob.m_20189_() + dirZ * hb.forward + rightZ * hb.lateral;
        double minY = this.mob.m_20186_() + hb.yOffset;
        return new AABB(cx - hb.halfSize, minY, cz - hb.halfSize, cx + hb.halfSize, minY + hb.height, cz + hb.halfSize);
    }

    private void applyDamageInBox(AABB box) {
        Predicate<LivingEntity> filter = e -> e.m_6084_() && e != this.mob && this.mob.m_6779_(e);
        List victims = this.mob.m_9236_().m_6443_(LivingEntity.class, box, filter);
        for (LivingEntity v : victims) {
            this.mob.m_7327_((Entity)v);
        }
    }

    public static final class AttackHitbox {
        public final double halfSize;
        public final double height;
        public final double forward;
        public final double lateral;
        public final double yOffset;

        public AttackHitbox(double halfSize, double height, double forward, double lateral, double yOffset) {
            this.halfSize = halfSize;
            this.height = height;
            this.forward = forward;
            this.lateral = lateral;
            this.yOffset = yOffset;
        }

        public static AttackHitbox of(double half, double h, double f, double lat, double y) {
            return new AttackHitbox(half, h, f, lat, y);
        }
    }

    public static interface AttackAnimBridge {
        public void setAttacking(boolean var1);
    }
}

