/*
 * Decompiled with CFR 0.152.
 */
package net.darkblade.mini_pekka.server.entity;

import java.util.UUID;
import net.darkblade.mini_pekka.server.entity.ai.SimpleAabbMeleeGoal;
import net.darkblade.mini_pekka.server.items.ModItems;
import net.darkblade.mini_pekka.sounds.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MiniPekka
extends TamableAnimal
implements GeoAnimatable {
    private static final EntityDataAccessor<Boolean> PANCAKES = SynchedEntityData.m_135353_(MiniPekka.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ATTACKING = SynchedEntityData.m_135353_(MiniPekka.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private long lastPancakeSfxTick = -200L;
    private long lastStepSfxTick = 0L;
    private static final double ATTACK_RANGE = 0.5;
    private static final double CHASE_SPEED = 1.6;
    private static final boolean REQUIRE_LOS = true;
    private static final int ATTACK_DURATION = 25;
    private static final int[] DAMAGE_FRAMES = new int[]{12};
    private static final int CD_BASE = 8;
    private static final SimpleAabbMeleeGoal.AttackHitbox BEAR_HITBOX = SimpleAabbMeleeGoal.AttackHitbox.of(0.5, 1.0, 1.0, 0.0, 0.3);

    public MiniPekka(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.m_21183_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22283_, 0.8).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 16.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, new SimpleAabbMeleeGoal<MiniPekka>(this, 0.5, 1.6, true, 25, DAMAGE_FRAMES, 8, BEAR_HITBOX, this::setAttacking));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.4, 8.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.PANCAKE.get()) && this.m_21824_() && player.m_20148_().equals(this.m_21805_())) {
            if (this.m_21223_() < this.m_21233_()) {
                if (!this.m_9236_().f_46443_) {
                    float healAmount = 6.0f;
                    this.m_5634_(healAmount);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.6, this.m_20189_(), 6, 0.3, 0.3, 0.3, 0.02);
                    long now = this.m_9236_().m_46467_();
                    if (now - this.lastPancakeSfxTick >= 120L) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.PANCAKES.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        this.lastPancakeSfxTick = now;
                    }
                    this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            return InteractionResult.CONSUME_PARTIAL;
        }
        if (this.m_21824_() && player.m_20148_().equals(this.m_21805_()) && stack.m_41619_()) {
            if (!this.m_9236_().f_46443_) {
                boolean sit = !this.m_21827_();
                this.m_21839_(sit);
                this.m_21837_(sit);
                this.m_21573_().m_26573_();
                this.m_6710_(null);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        this.m_19983_(new ItemStack((ItemLike)ModItems.MINI_PK_HEAD.get()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PANCAKES, (Object)false);
        this.f_19804_.m_135372_(DATA_ATTACKING, (Object)false);
    }

    public boolean hasPancakesSkin() {
        return (Boolean)this.f_19804_.m_135370_(PANCAKES);
    }

    public void setPancakesSkin(boolean value) {
        this.f_19804_.m_135381_(PANCAKES, (Object)value);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (!this.m_9236_().f_46443_) {
            boolean magic;
            boolean bl = magic = name != null && "pancakes".equalsIgnoreCase(name.getString().trim());
            if (magic) {
                this.setPancakesSkin(true);
                this.m_20340_(false);
                super.m_6593_(null);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.PANCAKES.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    private boolean hasScoreboardPancakes() {
        return this.m_19880_().contains("pancakes");
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean desired;
            boolean viaNameTag = this.m_8077_() && this.m_7770_() != null && "pancakes".equalsIgnoreCase(this.m_7770_().getString().trim());
            boolean viaScoreboard = this.hasScoreboardPancakes();
            boolean bl = desired = this.hasPancakesSkin() || viaNameTag || viaScoreboard;
            if (desired != this.hasPancakesSkin()) {
                this.setPancakesSkin(desired);
            }
            if (viaNameTag) {
                this.m_20340_(false);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_20096_() && !this.m_21825_()) {
            Vec3 vel = this.m_20184_();
            double speed2 = vel.f_82479_ * vel.f_82479_ + vel.f_82481_ * vel.f_82481_;
            if (speed2 > 0.001) {
                boolean chasingOrAttacking = this.m_5448_() != null || this.isAttacking();
                int interval = chasingOrAttacking ? 20 : 30;
                long now = this.m_9236_().m_46467_();
                if (now - this.lastStepSfxTick >= (long)interval) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.STEPS.get(), this.m_5720_(), 0.6f, 1.0f);
                    this.lastStepSfxTick = now;
                }
            }
        }
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DEATH.get();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("HasPancakesSkin", this.hasPancakesSkin());
        tag.m_128356_("LastPancakeSfx", this.lastPancakeSfxTick);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("HasPancakesSkin")) {
            this.setPancakesSkin(tag.m_128471_("HasPancakesSkin"));
        }
        if (tag.m_128441_("LastPancakeSfx")) {
            this.lastPancakeSfxTick = tag.m_128454_("LastPancakeSfx");
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate);
        controllers.add(new AnimationController[]{controller});
    }

    protected void m_6153_() {
        ++this.f_20919_;
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        if (this.f_20919_ >= 59 && !this.m_9236_().f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected <E extends MiniPekka> PlayState predicate(AnimationState<E> event) {
        if (this.f_20919_ > 0) {
            event.setAndContinue(RawAnimation.begin().thenPlay("death"));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.setAndContinue(RawAnimation.begin().thenLoop("sit"));
            return PlayState.CONTINUE;
        }
        if (this.isAttacking()) {
            event.setAndContinue(RawAnimation.begin().thenPlay("attack"));
            return PlayState.CONTINUE;
        }
        if (!event.isMoving()) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
    }

    public boolean m_6779_(LivingEntity target) {
        Player p;
        if (target instanceof Player && this.m_21830_((LivingEntity)(p = (Player)target))) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal other = (TamableAnimal)target;
            if (this.m_21824_() && other.m_21824_()) {
                UUID me = this.m_21805_();
                UUID them = other.m_21805_();
                if (me != null && me.equals(them)) {
                    return false;
                }
            }
        }
        return super.m_6779_(target);
    }

    private void setAttacking(boolean v) {
        boolean was = (Boolean)this.f_19804_.m_135370_(DATA_ATTACKING);
        this.f_19804_.m_135381_(DATA_ATTACKING, (Object)v);
        if (!this.m_9236_().f_46443_ && v && !was) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.ANA.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ATTACKING);
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob mate) {
        return null;
    }
}

