/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.common.block;

import com.teamabnormals.incubation.common.block.EmptyNestBlock;
import com.teamabnormals.incubation.common.block.entity.BirdNestBlockEntity;
import com.teamabnormals.incubation.core.registry.IncubationBlockEntityTypes;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class BirdNestBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    public static final IntegerProperty EGGS = IntegerProperty.m_61631_((String)"eggs", (int)1, (int)6);
    private final Supplier<? extends Item> egg;
    private final EmptyNestBlock emptyNest;

    public BirdNestBlock(Supplier<? extends Item> eggIn, EmptyNestBlock emptyNestIn, BlockBehaviour.Properties properties) {
        super(properties);
        this.egg = eggIn;
        this.emptyNest = emptyNestIn;
        this.emptyNest.addNest(this.egg, (Block)this);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public BirdNestBlock(ResourceLocation eggIn, EmptyNestBlock emptyNestIn, BlockBehaviour.Properties properties) {
        this(() -> (Item)ForgeRegistries.ITEMS.getValue(eggIn), emptyNestIn, properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_36326_()) {
            ItemStack itemstack = player.m_21120_(handIn);
            if (this.egg.get() != Items.f_41852_ && itemstack.m_41720_() == this.egg.get()) {
                int i = (Integer)state.m_61143_((Property)EGGS);
                if (i < 6) {
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i + 1)), 3);
                    return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                }
                return InteractionResult.CONSUME;
            }
            BirdNestBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.egg.get()));
            this.removeEgg(worldIn, pos, state);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    private void removeEgg(Level world, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)EGGS);
        if (i > 1) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 3);
        } else {
            world.m_7731_(pos, this.getEmptyNest().m_49966_(), 3);
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.getEgg());
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_280296_();
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        if (!worldIn.f_46443_ && !player.m_7500_() && this.getEgg() != null && (Integer)state.m_61143_((Property)EGGS) > 0) {
            BirdNestBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getEgg(), ((Integer)state.m_61143_((Property)EGGS)).intValue()));
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BirdNestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : BirdNestBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)IncubationBlockEntityTypes.BIRD_NEST.get()), BirdNestBlockEntity::serverTick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EGGS});
    }

    public Item getEgg() {
        return this.egg.get();
    }

    public EmptyNestBlock getEmptyNest() {
        return this.emptyNest;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)EGGS);
    }
}

