/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.mixin;

import com.teamabnormals.blueprint.core.api.BlueprintRabbitVariants;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Rabbit.class})
public abstract class RabbitMixin
extends Animal
implements VariantHolder<Rabbit.Variant> {
    protected RabbitMixin(EntityType<? extends Animal> animal, Level level) {
        super(animal, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128405_("RabbitType", ((Integer)this.f_19804_.m_135370_(Rabbit.f_29647_)).intValue());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.m_20088_().m_135381_(Rabbit.f_29647_, (Object)tag.m_128451_("RabbitType"));
    }

    @Inject(at={@At(value="RETURN")}, method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/Rabbit;"}, cancellable=true)
    private void getBreedOffspring(ServerLevel level, AgeableMob ageableMob, CallbackInfoReturnable<Rabbit> cir) {
        Rabbit rabbit = (Rabbit)cir.getReturnValue();
        int id = 0;
        if (this.f_19796_.m_188503_(20) != 0) {
            if (this.f_19796_.m_188499_() && ageableMob instanceof Rabbit) {
                Rabbit partner = (Rabbit)ageableMob;
                id = (Integer)partner.m_20088_().m_135370_(Rabbit.f_29647_);
            } else {
                id = (Integer)this.m_20088_().m_135370_(Rabbit.f_29647_);
            }
        } else {
            boolean foundVariant = false;
            for (BlueprintRabbitVariants.BlueprintRabbitVariant newVariant : BlueprintRabbitVariants.values()) {
                if (!newVariant.test((ServerLevelAccessor)level, this.m_20183_())) continue;
                id = newVariant.id();
                foundVariant = true;
                break;
            }
            if (!foundVariant) {
                id = Rabbit.m_262482_((LevelAccessor)level, (BlockPos)this.m_20183_()).m_262377_();
            }
        }
        rabbit.m_20088_().m_135381_(Rabbit.f_29647_, (Object)id);
        cir.setReturnValue((Object)rabbit);
    }

    @Inject(at={@At(value="RETURN")}, method={"finalizeSpawn"}, cancellable=true)
    private void finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnData, CompoundTag tag, CallbackInfoReturnable<SpawnGroupData> cir) {
        int id = ((Rabbit.Variant)this.m_28554_()).m_262377_();
        for (BlueprintRabbitVariants.BlueprintRabbitVariant newVariant : BlueprintRabbitVariants.values()) {
            if (!newVariant.test(level, this.m_20183_())) continue;
            id = newVariant.id();
            break;
        }
        if (spawnData instanceof BlueprintRabbitVariants.BlueprintRabbitGroupData) {
            BlueprintRabbitVariants.BlueprintRabbitGroupData groupData = (BlueprintRabbitVariants.BlueprintRabbitGroupData)((Object)spawnData);
            id = groupData.variant;
        } else {
            spawnData = new BlueprintRabbitVariants.BlueprintRabbitGroupData(id);
        }
        this.m_20088_().m_135381_(Rabbit.f_29647_, (Object)id);
        cir.setReturnValue((Object)super.m_6518_(level, difficulty, spawnType, spawnData, tag));
    }
}

