/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.structure;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.world.modification.structure.SimpleStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.common.world.modification.structure.WeightedStructureRepaletter;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.util.registry.BasicRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blueprint")
public final class StructureRepalleterManager {
    static final BasicRegistry<Codec<? extends StructureRepaletter>> REPALLETER_SERIALIZERS = new BasicRegistry();
    private static final IdentityHashMap<ResourceKey<Structure>, StructureRepaletterEntry[]> ASSIGNED_REPALLETERS = new IdentityHashMap();
    private static final ThreadLocal<ActiveData> ACTIVE_DATA = ThreadLocal.withInitial(ActiveData::new);

    @SubscribeEvent
    public static void onServerStarted(ServerAboutToStartEvent event) {
        ASSIGNED_REPALLETERS.clear();
        Set entries = event.getServer().m_206579_().m_175515_(BlueprintDataPackRegistries.STRUCTURE_REPALETTERS).m_6579_();
        IdentityHashMap<ResourceKey, ArrayList> assignedUnsortedEntries = new IdentityHashMap<ResourceKey, ArrayList>();
        for (Map.Entry entry : entries) {
            StructureRepaletterEntry structureRepaletterEntry = (StructureRepaletterEntry)entry.getValue();
            structureRepaletterEntry.structures().m_203614_().forEach(structureHolder -> assignedUnsortedEntries.computeIfAbsent((ResourceKey)structureHolder.m_203543_().orElseThrow(), __ -> new ArrayList()).add(structureRepaletterEntry));
        }
        assignedUnsortedEntries.forEach((location, structureRepaletterEntries) -> ASSIGNED_REPALLETERS.put((ResourceKey<Structure>)location, (StructureRepaletterEntry[])structureRepaletterEntries.stream().sorted(Comparator.comparing(StructureRepaletterEntry::priority)).toArray(StructureRepaletterEntry[]::new)));
    }

    public static synchronized void registerSerializer(ResourceLocation name, Codec<? extends StructureRepaletter> codec) {
        REPALLETER_SERIALIZERS.register(name, codec);
    }

    @Nullable
    public static StructureRepaletterEntry[] getRepalettersForStructure(ResourceKey<Structure> structure) {
        return ASSIGNED_REPALLETERS.get(structure);
    }

    public static void updateRandomSource(RandomSource random) {
        StructureRepalleterManager.ACTIVE_DATA.get().random = random;
    }

    public static void updateActiveRepaletters(StructureRepaletterEntry[] repaletters, @Nullable Holder<StructurePieceType> pieceType) {
        ArrayList<StructureRepaletter> activeRepaletters = StructureRepalleterManager.ACTIVE_DATA.get().repaletters;
        activeRepaletters.clear();
        if (repaletters == null) {
            return;
        }
        if (pieceType != null) {
            for (StructureRepaletterEntry entry : repaletters) {
                Optional<HolderSet<StructurePieceType>> pieces = entry.pieces();
                if (!pieces.isEmpty() && !pieces.get().m_203333_(pieceType)) continue;
                activeRepaletters.add(entry.repaletter());
            }
        } else {
            for (StructureRepaletterEntry entry : repaletters) {
                if (!entry.shouldApplyToAfterPlace()) continue;
                activeRepaletters.add(entry.repaletter());
            }
        }
    }

    public static BlockState getBlockState(ServerLevelAccessor level, BlockState state) {
        ActiveData activeData = ACTIVE_DATA.get();
        ArrayList<StructureRepaletter> activeRepaletters = activeData.repaletters;
        if (activeRepaletters.isEmpty()) {
            return state;
        }
        RandomSource random = activeData.random;
        for (StructureRepaletter repaletter : activeRepaletters) {
            BlockState repaletterState = repaletter.getReplacement(level, state, random);
            if (repaletterState == null) continue;
            return repaletterState;
        }
        return state;
    }

    public static void reset() {
        StructureRepalleterManager.ACTIVE_DATA.get().repaletters.clear();
    }

    static {
        StructureRepalleterManager.registerSerializer(new ResourceLocation("blueprint", "simple"), SimpleStructureRepaletter.CODEC);
        StructureRepalleterManager.registerSerializer(new ResourceLocation("blueprint", "weighted"), WeightedStructureRepaletter.CODEC);
    }

    private static final class ActiveData {
        private final ArrayList<StructureRepaletter> repaletters = new ArrayList(0);
        private RandomSource random;

        private ActiveData() {
        }
    }
}

