/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.advancement.modification.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierSerializers;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.AdvancementModifier;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.ArrayUtils;

public record CriteriaModifier(Map<String, Criterion> criteria, Optional<String[][]> requirements, boolean shouldReplaceRequirements, Optional<List<IndexedRequirementsEntry>> indexedRequirements) implements AdvancementModifier<CriteriaModifier>
{
    public static final Field REQUIREMENTS_FIELD = ObfuscationReflectionHelper.findField(Advancement.Builder.class, (String)"f_138337_");

    public static Builder builder(String modId) {
        return new Builder(modId);
    }

    @Override
    public void modify(Advancement.Builder builder) {
        builder.m_138405_().putAll(this.criteria);
        try {
            Optional<List<IndexedRequirementsEntry>> indexedRequirements;
            Optional<String[][]> requirements = this.requirements;
            if (requirements.isPresent()) {
                String[][] theseRequirements = requirements.get();
                if (this.shouldReplaceRequirements) {
                    REQUIREMENTS_FIELD.set(builder, theseRequirements);
                } else {
                    REQUIREMENTS_FIELD.set(builder, ArrayUtils.addAll((Object[])((String[][])REQUIREMENTS_FIELD.get(builder)), (Object[])theseRequirements));
                }
            }
            if ((indexedRequirements = this.indexedRequirements).isPresent()) {
                String[][] builderRequirements = (String[][])REQUIREMENTS_FIELD.get(builder);
                int length = builderRequirements.length;
                for (IndexedRequirementsEntry entry : indexedRequirements.get()) {
                    int index = entry.index;
                    if (index >= length) continue;
                    builderRequirements[index] = entry.replace ? entry.requirements : (String[])ArrayUtils.addAll((Object[])builderRequirements[index], (Object[])entry.requirements);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public Serializer getSerializer() {
        return AdvancementModifierSerializers.CRITERIA;
    }

    public static final class Builder {
        private final String modId;
        private final Map<String, Criterion> criteria = Maps.newLinkedHashMap();
        private final List<IndexedRequirementsEntry> indexedRequirements = new LinkedList<IndexedRequirementsEntry>();
        @Nullable
        private String[][] requirements;
        private boolean shouldReplaceRequirements = false;

        private Builder(String modId) {
            this.modId = modId;
        }

        public Builder addCriterionRaw(String key, Criterion criterion) {
            if (this.criteria.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate criterion: " + key);
            }
            this.criteria.put(key, criterion);
            return this;
        }

        public Builder addCriterion(String key, Criterion criterion) {
            return this.addCriterionRaw(this.modId + ":" + key, criterion);
        }

        public Builder addCriterion(String key, CriterionTriggerInstance trigger) {
            this.addCriterion(key, new Criterion(trigger));
            return this;
        }

        public Builder requirements(String[][] requirements) {
            this.requirements = requirements;
            return this;
        }

        public Builder requirements(Collection<String> requirements, RequirementsStrategy requirementsStrategy) {
            this.requirements = requirementsStrategy.m_15985_(requirements);
            return this;
        }

        public Builder requirements(RequirementsStrategy requirementsStrategy) {
            this.requirements = requirementsStrategy.m_15985_(this.criteria.keySet());
            return this;
        }

        public Builder shouldReplaceRequirements(boolean shouldReplaceRequirements) {
            this.shouldReplaceRequirements = shouldReplaceRequirements;
            return this;
        }

        public Builder addIndexedRequirementsRaw(int index, boolean replace, String ... requirements) {
            this.indexedRequirements.add(new IndexedRequirementsEntry(index, replace, requirements));
            return this;
        }

        public Builder addIndexedRequirements(int index, boolean replace, String ... requirements) {
            int length = requirements.length;
            String[] prefixedRequirements = new String[length];
            String prefix = this.modId + ":";
            for (int i = 0; i < length; ++i) {
                prefixedRequirements[i] = prefix + requirements[i];
            }
            return this.addIndexedRequirementsRaw(index, replace, prefixedRequirements);
        }

        public CriteriaModifier build() {
            Map<String, Criterion> criteria = this.criteria;
            if (criteria.isEmpty()) {
                throw new IllegalStateException("Cannot have no criteria!");
            }
            return new CriteriaModifier((Map<String, Criterion>)ImmutableMap.copyOf(criteria), Optional.ofNullable(this.requirements), this.shouldReplaceRequirements, Optional.of(ImmutableList.copyOf(this.indexedRequirements)));
        }
    }

    public record IndexedRequirementsEntry(int index, boolean replace, String[] requirements) {
    }

    public static final class Serializer
    implements AdvancementModifier.Serializer<CriteriaModifier> {
        @Override
        public JsonElement serialize(CriteriaModifier modifier, Void additional) throws JsonParseException {
            JsonObject jsonObject = new JsonObject();
            JsonObject criteriaObject = new JsonObject();
            Map<String, Criterion> criteria = modifier.criteria;
            criteria.forEach((key, criterion) -> criteriaObject.add(key, criterion.m_11425_()));
            jsonObject.add("criteria", (JsonElement)criteriaObject);
            modifier.requirements.ifPresent(requirements -> {
                JsonArray requirementsArray = new JsonArray();
                for (String[] astring : requirements) {
                    JsonArray jsonarray = new JsonArray();
                    for (String s : astring) {
                        if (!criteria.containsKey(s)) {
                            throw new JsonParseException("Unknown criterion: " + s);
                        }
                        jsonarray.add(s);
                    }
                    requirementsArray.add((JsonElement)jsonarray);
                }
                jsonObject.add("requirements", (JsonElement)requirementsArray);
                jsonObject.addProperty("should_replace_requirements", Boolean.valueOf(modifier.shouldReplaceRequirements));
            });
            modifier.indexedRequirements.ifPresent(list -> {
                if (!list.isEmpty()) {
                    JsonArray indexedRequirements = new JsonArray();
                    list.forEach(indexedRequirementsEntry -> {
                        JsonObject entry = new JsonObject();
                        entry.addProperty("index", (Number)indexedRequirementsEntry.index);
                        entry.addProperty("replace", Boolean.valueOf(indexedRequirementsEntry.replace));
                        JsonArray requirementsArray = new JsonArray();
                        for (String key : indexedRequirementsEntry.requirements) {
                            if (!criteria.containsKey(key)) {
                                throw new JsonParseException("Unknown criterion: " + key);
                            }
                            requirementsArray.add(key);
                        }
                        entry.add("requirements", (JsonElement)requirementsArray);
                        indexedRequirements.add((JsonElement)entry);
                    });
                    jsonObject.add("indexed_requirements", (JsonElement)indexedRequirements);
                }
            });
            return jsonObject;
        }

        @Override
        public CriteriaModifier deserialize(JsonElement element, DeserializationContext additional) throws JsonParseException {
            JsonObject object = element.getAsJsonObject();
            Map criteria = Criterion.m_11426_((JsonObject)GsonHelper.m_13930_((JsonObject)object, (String)"criteria"), (DeserializationContext)additional);
            if (criteria.isEmpty()) {
                throw new JsonParseException("Criteria cannot be empty!");
            }
            Optional<String[][]> requirements = Optional.empty();
            boolean shouldReplaceRequirements = false;
            if (GsonHelper.m_13900_((JsonObject)object, (String)"requirements")) {
                int i;
                JsonArray jsonArray = GsonHelper.m_13832_((JsonObject)object, (String)"requirements", (JsonArray)new JsonArray());
                String[][] requirementsArray = new String[jsonArray.size()][];
                for (i = 0; i < jsonArray.size(); ++i) {
                    JsonArray requirementsArray2 = GsonHelper.m_13924_((JsonElement)jsonArray.get(i), (String)("requirements[" + i + "]"));
                    requirementsArray[i] = new String[requirementsArray2.size()];
                    for (int j = 0; j < requirementsArray2.size(); ++j) {
                        requirementsArray[i][j] = GsonHelper.m_13805_((JsonElement)requirementsArray2.get(j), (String)("requirements[" + i + "][" + j + "]"));
                    }
                }
                if (requirementsArray.length == 0) {
                    requirementsArray = new String[criteria.size()][];
                    i = 0;
                    for (String key : criteria.keySet()) {
                        requirementsArray[i++] = new String[]{key};
                    }
                }
                for (String[] requirementArray : requirementsArray) {
                    if (requirementArray.length == 0 && criteria.isEmpty()) {
                        throw new JsonParseException("Requirement entry cannot be empty");
                    }
                    for (String criterion : requirementArray) {
                        if (criteria.containsKey(criterion)) continue;
                        throw new JsonParseException("Unknown required criterion '" + criterion + "'");
                    }
                }
                requirements = Optional.of(requirementsArray);
                shouldReplaceRequirements = GsonHelper.m_13912_((JsonObject)object, (String)"should_replace_requirements");
            }
            Optional<List<IndexedRequirementsEntry>> indexedRequirements = Optional.empty();
            if (GsonHelper.m_13900_((JsonObject)object, (String)"indexed_requirements")) {
                JsonArray indexedRequirementsArray = GsonHelper.m_13933_((JsonObject)object, (String)"indexed_requirements");
                LinkedList parsedEntries = new LinkedList();
                indexedRequirementsArray.forEach(entryElement -> {
                    JsonObject entry = entryElement.getAsJsonObject();
                    int index = GsonHelper.m_13927_((JsonObject)entry, (String)"index");
                    JsonArray requirementsArray = GsonHelper.m_13933_((JsonObject)entry, (String)"requirements");
                    int size = requirementsArray.size();
                    if (size == 0) {
                        throw new JsonParseException("Requirements cannot be empty!");
                    }
                    String[] keys = new String[size];
                    for (int i = 0; i < size; ++i) {
                        String string = requirementsArray.get(i).getAsString();
                        if (!criteria.containsKey(string)) {
                            throw new JsonParseException("Unknown required criterion '" + string + "'");
                        }
                        keys[i] = string;
                    }
                    parsedEntries.add(new IndexedRequirementsEntry(index, GsonHelper.m_13912_((JsonObject)entry, (String)"replace"), keys));
                });
                indexedRequirements = Optional.of(parsedEntries);
            }
            return new CriteriaModifier(criteria, requirements, shouldReplaceRequirements, indexedRequirements);
        }
    }
}

