/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.heartstone.Heartstone;
import net.mehvahdjukaar.heartstone.HeartstoneData;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.mehvahdjukaar.heartstone.compat.CurioCompat;
import net.mehvahdjukaar.heartstone.compat.TrinketsCompat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HeartstoneItem
extends Item {
    public HeartstoneItem() {
        super(new Item.Properties().m_41497_(Rarity.RARE).m_41487_(2));
    }

    public boolean m_5812_(ItemStack pStack) {
        return HeartstoneItem.getHeartstoneId(pStack) != null;
    }

    @Nullable
    public static Long getHeartstoneId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Id")) {
            return tag.m_128454_("Id");
        }
        return null;
    }

    public static boolean isCracked(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("Cracked");
    }

    public static void crack(ItemStack stack, Entity entity) {
        stack.m_41784_().m_128379_("Cracked", true);
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (p.m_21205_() == stack) {
                p.m_21166_(EquipmentSlot.MAINHAND);
            }
            if (p.m_21206_() == stack) {
                p.m_21166_(EquipmentSlot.OFFHAND);
            }
        }
        entity.m_5496_(SoundEvents.f_144050_, 0.6f, 1.3f);
        entity.m_5496_(SoundEvents.f_12502_, 1.3f, 0.7f);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player p;
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (HeartstoneItem.isCracked(stack) && (level.m_46467_() + 1L) % 40L == 0L && entity instanceof Player && HeartstoneItem.getBoundPlayer(p = (Player)entity, stack, false) != null) {
            stack.m_41749_("Cracked");
            entity.m_5496_(SoundEvents.f_276532_, 0.8f, 0.7f);
            entity.m_5496_(SoundEvents.f_215677_, 1.1f, 1.2f);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pHand) {
        ItemStack itemstack = player.m_21120_(pHand);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        Player otherPlayer = HeartstoneItem.getBoundPlayer(player, itemstack, true);
        if (otherPlayer != null) {
            NetworkHandler.sendHeartstoneParticles(player, otherPlayer);
        } else {
            pLevel.m_6269_(null, (Entity)player, SoundEvents.f_144244_, player.m_5720_(), 0.6f, 0.7f);
        }
        player.m_36335_().m_41524_((Item)this, 60);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @Nullable
    public static Player getBoundPlayer(Player player, ItemStack itemstack, boolean sameDim) {
        Level level;
        Long id = HeartstoneItem.getHeartstoneId(itemstack);
        if (id != null && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PlayerList players = serverLevel.m_7654_().m_6846_();
            for (Player targetPlayer : players.m_11314_()) {
                if (!HeartstoneItem.arePlayersBound(player, itemstack, targetPlayer, sameDim)) continue;
                return targetPlayer;
            }
        }
        return null;
    }

    public static List<ItemStack> getAllHeartstones(Player player) {
        ItemStack s;
        ArrayList<ItemStack> found = new ArrayList<ItemStack>();
        player.m_150109_().f_35974_.stream().filter(i -> i.m_41720_() instanceof HeartstoneItem).forEach(found::add);
        if (Heartstone.TRINKETS && !(s = TrinketsCompat.getHeartstone(player)).m_41619_()) {
            found.add(s);
        }
        if (Heartstone.CURIO && !(s = CurioCompat.getHeartstone(player)).m_41619_()) {
            found.add(s);
        }
        return found;
    }

    public static boolean arePlayersBound(Player pPlayer, ItemStack original, Player target, boolean sameDimension) {
        if (sameDimension && target.m_9236_().m_46472_() != pPlayer.m_9236_().m_46472_()) {
            return false;
        }
        if (target != pPlayer) {
            ItemStack s;
            Long id = HeartstoneItem.getHeartstoneId(original);
            if (id == null) {
                return false;
            }
            Inventory inv = target.m_150109_();
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack s2 = inv.m_8020_(i);
                if (!HeartstoneItem.hasMatchingId(id, s2)) continue;
                return true;
            }
            if (Heartstone.TRINKETS && !(s = TrinketsCompat.getHeartstone(target)).m_41619_() && HeartstoneItem.hasMatchingId(id, s)) {
                return true;
            }
            if (Heartstone.CURIO) {
                ItemStack s3 = CurioCompat.getHeartstone(target);
                return !s3.m_41619_() && HeartstoneItem.hasMatchingId(id, s3);
            }
        }
        return false;
    }

    public static boolean hasMatchingId(Long id, ItemStack s) {
        if (s.m_41720_() instanceof HeartstoneItem) {
            Long other = HeartstoneItem.getHeartstoneId(s);
            return other != null && other.equals(id);
        }
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        Long id = HeartstoneItem.getHeartstoneId(pStack);
        if (id != null) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"message.heartstone.id", (Object[])new Object[]{id}));
        }
        if (HeartstoneItem.isCracked(pStack)) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"message.heartstone.cracked"));
        }
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        super.m_7836_(pStack, pLevel, pPlayer);
        CompoundTag tag = pStack.m_41784_();
        if (!tag.m_128441_("Id") && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            tag.m_128356_("Id", HeartstoneData.getNewId(serverLevel));
        }
    }
}

