/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.lang.ref.WeakReference;
import net.mehvahdjukaar.heartstone.Heartstone;
import net.mehvahdjukaar.heartstone.HeartstoneItem;
import net.mehvahdjukaar.heartstone.HeartstoneParticle;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class HeartstoneClient {
    private static WeakReference<Player> glowPlayer;
    private static int cooldown;

    public static void init() {
        ClientHelper.addParticleRegistration(HeartstoneClient::registerParticles);
        ClientHelper.addClientSetup(() -> ItemProperties.m_174570_((Item)Heartstone.HEARTSTONE_ITEM.get(), (ResourceLocation)Heartstone.res("cracked"), (itemStack, clientLevel, livingEntity, i) -> HeartstoneItem.isCracked(itemStack) ? 1.0f : 0.0f));
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((ParticleType)Heartstone.HEARTSTONE_PARTICLE.get(), HeartstoneParticle.Factory::new);
        event.register((ParticleType)Heartstone.HEARTSTONE_PARTICLE_EMITTER.get(), HeartstoneParticle.EmitterFactory::new);
    }

    public static void spawnParticle(NetworkHandler.ClientBoundSpawnHeartstoneParticlePacket message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level level = player.m_9236_();
        int d = Heartstone.HIGHLIGHT_DISTANCE.get();
        if (Heartstone.HIGHLIGHT.get().booleanValue() && message.from.equals(player.m_20148_()) && message.dist.m_82556_() < (double)(d * d)) {
            HeartstoneClient.highlightPlayer(level.m_46003_(message.target));
        }
        level.m_7106_((ParticleOptions)Heartstone.HEARTSTONE_PARTICLE_EMITTER.get(), message.pos.f_82479_, message.pos.f_82480_, message.pos.f_82481_, message.dist.f_82479_, message.dist.f_82480_, message.dist.f_82481_);
    }

    public static void onClientTick() {
        if (cooldown != 0 && --cooldown == 0) {
            glowPlayer = null;
        }
    }

    public static void highlightPlayer(Player player) {
        glowPlayer = new WeakReference<Player>(player);
        cooldown = Heartstone.HIGHLIGHT_DURATION.get();
    }

    public static boolean isPlayerHighlighted(Entity player) {
        if (glowPlayer != null) {
            return glowPlayer.get() == player;
        }
        return false;
    }
}

