/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.heartstone.HeartstoneClient;
import net.mehvahdjukaar.heartstone.HeartstoneItem;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.DynamicHolder;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Heartstone {
    public static final String MOD_ID = "heartstone";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean CURIO = PlatHelper.isModLoaded((String)"curio");
    public static final boolean TRINKETS = PlatHelper.isModLoaded((String)"trinkets");
    public static final Supplier<SoundEvent> HEARTSTONE_SOUND = RegHelper.registerSound((ResourceLocation)Heartstone.res("item.heartstone"));
    public static final Supplier<SimpleParticleType> HEARTSTONE_PARTICLE = RegHelper.registerParticle((ResourceLocation)Heartstone.res("heartstone_trail"));
    public static final Supplier<SimpleParticleType> HEARTSTONE_PARTICLE_EMITTER = RegHelper.registerParticle((ResourceLocation)Heartstone.res("heartstone_emitter"));
    public static final Supplier<Item> HEARTSTONE_ITEM = RegHelper.registerItem((ResourceLocation)Heartstone.res("heartstone"), HeartstoneItem::new);
    public static final Supplier<BannerPattern> HEART_PATTERN = RegHelper.registerBannerPattern((ResourceLocation)Heartstone.res("heart"), (String)Heartstone.res("heart").toString());
    public static final TagKey<BannerPattern> HEART_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256969_, (ResourceLocation)Heartstone.res("pattern_item/heart"));
    public static final Supplier<Item> HEART_PATTERN_ITEM = RegHelper.registerItem((ResourceLocation)Heartstone.res("heart_banner_pattern"), () -> new BannerPatternItem(HEART_TAG, new Item.Properties().m_41497_(Rarity.RARE)));
    public static final Supplier<Integer> HIGHLIGHT_COLOR;
    public static final Supplier<Boolean> HIGHLIGHT;
    public static final Supplier<Integer> HIGHLIGHT_DISTANCE;
    public static final Supplier<Integer> HIGHLIGHT_DURATION;
    public static final DynamicHolder<MapDecorationType<?, ?>> HEARTSTONE_MARKER;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        PlatHelper.addCommonSetup(Heartstone::commonSetup);
        if (PlatHelper.getPhysicalSide().isClient()) {
            HeartstoneClient.init();
            ClientHelper.registerOptionalTexturePack((ResourceLocation)Heartstone.res("heart_particles"));
        }
        RegHelper.addItemsToTabsRegistration(Heartstone::addItemsToTabs);
        MapDataRegistry.addDynamicServerMarkersEvent(Heartstone::getDynamicDecorations);
        MoonlightEventsHelper.addListener(Heartstone::onPlayerDeath, IDropItemOnDeathEvent.class);
    }

    private static Set<MapBlockMarker<?>> getDynamicDecorations(Player player, int mapId, MapItemSavedData data) {
        List<ItemStack> list = HeartstoneItem.getAllHeartstones(player);
        ArrayList<Player> visiblePlayers = new ArrayList<Player>();
        Iterator iterator = new ArrayList(player.m_9236_().m_7654_().m_6846_().m_11314_()).iterator();
        for (ItemStack i : list) {
            boolean found = false;
            while (iterator.hasNext() && !found) {
                Player targetPlayer = (Player)iterator.next();
                HeartstoneItem cfr_ignored_0 = (HeartstoneItem)i.m_41720_();
                if (!HeartstoneItem.arePlayersBound(player, i, targetPlayer, true)) continue;
                visiblePlayers.add(targetPlayer);
                iterator.remove();
                found = true;
            }
        }
        HashSet markers = new HashSet();
        for (Player p : visiblePlayers) {
            MapBlockMarker marker = ((MapDecorationType)HEARTSTONE_MARKER.m_203334_()).createEmptyMarker();
            marker.setPos(p.m_20097_());
            marker.setRotation((int)p.m_146908_());
            marker.setName(p.m_5446_());
            markers.add(marker);
        }
        return markers;
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
        event.addAfter(CreativeModeTabs.f_256968_, i -> i.m_150930_(Items.f_42725_), new ItemLike[]{(ItemLike)HEART_PATTERN_ITEM.get()});
        event.addBefore(CreativeModeTabs.f_256869_, i -> i.m_150930_(Items.f_42522_), new ItemLike[]{(ItemLike)HEARTSTONE_ITEM.get()});
    }

    public static void commonSetup() {
        NetworkHandler.registerMessages();
    }

    public static void onPlayerDeath(IDropItemOnDeathEvent event) {
        Player p = event.getPlayer();
        if (event.isBeforeDrop()) {
            List<ItemStack> list = HeartstoneItem.getAllHeartstones(p);
            for (ItemStack h : list) {
                Player target = HeartstoneItem.getBoundPlayer(p, h, false);
                if (target == null) continue;
                Long id = HeartstoneItem.getHeartstoneId(h);
                List<ItemStack> targetList = HeartstoneItem.getAllHeartstones(target);
                for (ItemStack th : targetList) {
                    if (!HeartstoneItem.hasMatchingId(id, th)) continue;
                    HeartstoneItem.crack(th, (Entity)target);
                }
            }
        }
    }

    static {
        ConfigBuilder config = ConfigBuilder.create((ResourceLocation)Heartstone.res("client"), (ConfigType)ConfigType.CLIENT);
        config.push("highlight");
        HIGHLIGHT_COLOR = config.comment("Highlight color").defineColor("color", 16738511);
        HIGHLIGHT = config.define("enabled", true);
        HIGHLIGHT_DISTANCE = config.comment("Distance at which the player highlight will take effect").define("distance", 20, 0, 10000);
        HIGHLIGHT_DURATION = config.define("duration", 100, 0, 10000);
        config.pop();
        config.buildAndRegister();
        HEARTSTONE_MARKER = DynamicHolder.of((ResourceLocation)Heartstone.res(MOD_ID), (ResourceKey)MapDataRegistry.REGISTRY_KEY);
    }
}

