/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.animation.AnimationNew;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.AnimationFrameData;
import com.tom.cpm.shared.parts.anim.AnimationFrameDataType;
import com.tom.cpm.shared.parts.anim.AnimatorChannel;
import com.tom.cpm.shared.parts.anim.Float3Driver;
import com.tom.cpm.shared.parts.anim.TagType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializedAnimation {
    public static final int ADDITIVE = 1;
    public int triggerID;
    public int priority;
    public int duration;
    public Map<Integer, AnimatorChannel> animatorChannels = new HashMap<Integer, AnimatorChannel>();
    private int chID = 0;

    public int addChannel(AnimatorChannel c) {
        int i = this.chID++;
        this.animatorChannels.put(i, c);
        return i;
    }

    public static void newAnimation(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedAnimation cA = new SerializedAnimation();
        cA.triggerID = block.readVarInt();
        cA.priority = block.readSignedVarInt();
        cA.duration = block.readVarInt();
        state.newAnimation(cA);
    }

    public static void addCubesToChannels(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedAnimation cA = state.getAnim();
        int cubeCount = block.readVarInt();
        int intChCount = block.readVarInt();
        int flags = block.read();
        for (int i = 0; i < cubeCount; ++i) {
            boolean additive;
            int id = block.readVarInt();
            boolean bl = additive = (flags & 1) != 0;
            if (intChCount == 12) {
                Float3Driver.make(new AnimatorChannel.CubePosDriver(id, additive), InterpolatorChannel.POS_X, InterpolatorChannel.POS_Y, InterpolatorChannel.POS_Z, (ic, ac) -> cA.addChannel((AnimatorChannel)ac));
                Float3Driver.make(new AnimatorChannel.CubeRotDriver(id, additive), InterpolatorChannel.ROT_X, InterpolatorChannel.ROT_Y, InterpolatorChannel.ROT_Z, (ic, ac) -> cA.addChannel((AnimatorChannel)ac));
                Float3Driver.make(new AnimatorChannel.CubeColorDriver(id, additive), InterpolatorChannel.COLOR_R, InterpolatorChannel.COLOR_G, InterpolatorChannel.COLOR_B, (ic, ac) -> cA.addChannel((AnimatorChannel)ac));
                Float3Driver.make(new AnimatorChannel.CubeScaleDriver(id, additive), InterpolatorChannel.SCALE_X, InterpolatorChannel.SCALE_Y, InterpolatorChannel.SCALE_Z, (ic, ac) -> cA.addChannel((AnimatorChannel)ac));
            }
            cA.animatorChannels.put(cA.chID++, new AnimatorChannel(new AnimatorChannel.CubeVisDriver(id)));
        }
    }

    private static void writeCubeMaps(List<Integer> cubes, IOHelper dout, boolean add) throws IOException {
        if (cubes.isEmpty()) {
            return;
        }
        try (IOHelper d = dout.writeNextObjectBlock(TagType.CUBES_TO_CHANNELS);){
            d.writeVarInt(cubes.size());
            d.writeVarInt(InterpolatorChannel.VALUES.length);
            int flags = 0;
            if (add) {
                flags |= 1;
            }
            d.writeVarInt(flags);
            for (int i = 0; i < cubes.size(); ++i) {
                d.writeVarInt(cubes.get(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(IOHelper dout) throws IOException {
        try (IOHelper d = dout.writeNextObjectBlock(TagType.NEW_ANIM);){
            d.writeVarInt(this.triggerID);
            d.writeSignedVarInt(this.priority);
            d.writeVarInt(this.duration);
        }
        ArrayList<Integer> cubes = new ArrayList<Integer>();
        boolean add = false;
        for (int j = 0; j < this.animatorChannels.size(); ++j) {
            AnimatorChannel ac = this.animatorChannels.get(j);
            if (!ac.isMappedCube()) throw new RuntimeException("Can't export non cube mapped channels");
            Float3Driver.Float3Consumer f3c = Float3Driver.getFromPart(ac.part);
            if (f3c == null || !(f3c instanceof AnimatorChannel.CubePosDriver)) throw new IOException("Misaligned cube info");
            AnimatorChannel.CubePosDriver cfd = (AnimatorChannel.CubePosDriver)f3c;
            j += InterpolatorChannel.VALUES.length;
            cubes.add(cfd.cubeId);
            add = cfd.additive;
        }
        SerializedAnimation.writeCubeMaps(cubes, dout, add);
        HashMap<AnimationFrameDataType, List> framesByType = new HashMap<AnimationFrameDataType, List>();
        for (int j = 0; j < this.animatorChannels.size(); ++j) {
            AnimationFrameData frm = this.animatorChannels.get((Object)Integer.valueOf((int)j)).frameData;
            if (frm == null) continue;
            framesByType.computeIfAbsent(frm.getType(), __ -> new ArrayList()).add(new AnimFrame<AnimationFrameData>(j, frm));
        }
        for (Map.Entry e : framesByType.entrySet()) {
            ((AnimationFrameDataType)((Object)e.getKey())).write((List)e.getValue(), dout);
        }
    }

    public String toString() {
        return "Animation: " + this.triggerID;
    }

    public IAnimation compile(ModelDefinition def) {
        AnimationNew a = new AnimationNew(this.priority, this.duration);
        this.animatorChannels.values().forEach(ac -> ac.addToAnim(a, def));
        return a;
    }

    public static class AnimFrame<T extends AnimationFrameData> {
        public final int channel;
        public final T data;

        public AnimFrame(int channel, T data) {
            this.channel = channel;
            this.data = data;
        }
    }
}

