/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParameterDetails {
    public static final ParameterDetails DEFAULT = new ParameterDetails(2, 0);
    private byte[] syncDefault;
    private byte[] localDefault;

    private ParameterDetails() {
    }

    public ParameterDetails(int syncSize, int localSize) {
        this.syncDefault = new byte[syncSize];
        this.localDefault = new byte[localSize];
    }

    public ParameterDetails(byte[] syncDefault, byte[] localDefault) {
        this.syncDefault = syncDefault;
        this.localDefault = localDefault;
    }

    public static void parse(IOHelper block, AnimLoaderState state) throws IOException {
        ParameterDetails params = new ParameterDetails();
        params.syncDefault = block.readByteArray();
        params.localDefault = block.readByteArray();
        state.setParameters(params);
    }

    public void write(IOHelper block) throws IOException {
        block.writeByteArray(this.syncDefault);
        block.writeByteArray(this.localDefault);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.localDefault);
        result = 31 * result + Arrays.hashCode(this.syncDefault);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterDetails other = (ParameterDetails)obj;
        if (!Arrays.equals(this.localDefault, other.localDefault)) {
            return false;
        }
        return Arrays.equals(this.syncDefault, other.syncDefault);
    }

    public String toString() {
        return "Sync Parameter Count: " + this.syncDefault.length + "\n\t" + Arrays.toString(this.syncDefault);
    }

    public byte[] createSyncParams() {
        return Arrays.copyOf(this.syncDefault, this.syncDefault.length);
    }

    public byte getDefaultParam(int parameter) {
        if (parameter >= this.syncDefault.length) {
            Log.error("Parameter out of bounds", new IndexOutOfBoundsException(parameter + ", len=" + this.syncDefault.length));
            return 0;
        }
        return parameter >= 0 && parameter < this.syncDefault.length ? this.syncDefault[parameter] : (byte)0;
    }

    public static class ParameterAllocator {
        private List<Integer> syncBytes = new ArrayList<Integer>();
        private int poseCounter = 1;
        private int gestureCounter = 1;
        private int bitCount;
        private int bitMask;
        private int bitParam;

        public ParameterAllocator() {
            this.syncBytes.add(0);
            this.syncBytes.add(0);
        }

        public ParameterDetails finish() {
            if (this.bitParam != 0) {
                this.syncBytes.set(this.bitParam, this.bitMask);
            }
            byte[] dt = new byte[this.syncBytes.size()];
            for (int i = 0; i < dt.length; ++i) {
                dt[i] = this.syncBytes.get(i).byteValue();
            }
            return new ParameterDetails(dt, new byte[0]);
        }

        public int allocByteSync(String id, byte defaultValue) {
            int i = this.syncBytes.size();
            this.syncBytes.add(Byte.toUnsignedInt(defaultValue));
            return i;
        }

        public BitInfo allocBitSync(String id, boolean defaultValue) {
            if (this.bitCount == 0) {
                if (this.bitParam != 0) {
                    this.syncBytes.set(this.bitParam, this.bitMask);
                }
                this.bitParam = this.allocByteSync("", (byte)0);
                this.bitMask = 0;
                this.bitCount = 8;
            }
            --this.bitCount;
            this.bitMask |= (defaultValue ? 1 : 0) << this.bitCount;
            int valMask = 1 << this.bitCount;
            return new BitInfo(this.bitParam, valMask);
        }

        public int newPose(String id) {
            return this.poseCounter++;
        }

        public int newGesture(String id) {
            return this.gestureCounter++;
        }

        public void setDefaultValue(int id, int defaultValue) {
            this.syncBytes.set(id, defaultValue);
        }

        public static class BitInfo {
            public final int param;
            public final int mask;

            public BitInfo(int param, int mask) {
                this.param = param;
                this.mask = mask;
            }
        }
    }
}

