/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network.packet;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.packet.NBTC2S;
import com.tom.cpm.shared.network.packet.PluginMessageS2C;
import java.io.IOException;

public class PluginMessageC2S
extends NBTC2S {
    private String id;
    private byte flags;

    public PluginMessageC2S() {
    }

    public PluginMessageC2S(String msgID, NBTTagCompound data, int flags) {
        super(data);
        this.id = msgID;
        this.flags = (byte)flags;
    }

    @Override
    public void write(IOHelper pb) throws IOException {
        pb.writeUTF(this.id);
        super.write(pb);
        pb.writeByte(this.flags);
    }

    @Override
    public void read(IOHelper pb) throws IOException {
        this.id = pb.readUTF();
        super.read(pb);
        this.flags = pb.readByte();
    }

    @Override
    public <P> void handle(NetHandler<?, P, ?> handler, NetH.ServerNetH from, P player) {
        if ((this.flags & 1) != 0 || (this.flags & 2) != 0) {
            handler.sendPacketToTracking(player, new PluginMessageS2C(this.id, handler.getPlayerId(player), this.tag));
            if ((this.flags & 2) != 0) {
                from.cpm$getEncodedModelData().pluginStates.put(this.id, this.tag);
            }
        } else {
            MinecraftCommonAccess.get().getApi().commonApi().handlePacket(this.id, this.tag, player);
        }
    }
}

