/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.ListPicker;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.editor.CopyTransformEffect;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.elements.ModelElement;
import java.util.ArrayList;
import java.util.List;

public class CopyTransformSettingsPopup
extends PopupPanel {
    public CopyTransformSettingsPopup(Frame frm, Editor e, CopyTransformEffect cte) {
        super(frm.getGui());
        this.setBounds(new Box(0, 0, 300, 400));
        FlowLayout layout = new FlowLayout(this, 4, 1);
        ArrayList<CTOrigin> elems = new ArrayList<CTOrigin>();
        this.walkElements(0, e.elements, elems);
        ListPicker<CTOrigin> picker = new ListPicker<CTOrigin>(frm, elems);
        if (cte.from != null) {
            picker.setSelected(elems.stream().filter(c -> c.elem == cte.from).findFirst().orElse(null));
        }
        picker.setListLoader(l -> {
            l.setRenderer(CTOrigin::draw);
            l.setGetWidth(CTOrigin::width);
        });
        picker.setBounds(new Box(5, 0, 280, 20));
        this.addElement(picker);
        boolean[] pos = new boolean[]{cte.copyPX, cte.copyPY, cte.copyPZ};
        boolean[] rot = new boolean[]{cte.copyRX, cte.copyRY, cte.copyRZ};
        boolean[] rsc = new boolean[]{cte.copySX, cte.copySY, cte.copySZ};
        this.createPanel("position", pos);
        this.createPanel("rotation", rot);
        this.createPanel("render_scale", rsc);
        Panel miscTr = new Panel(this.gui);
        miscTr.setBounds(new Box(5, 0, 290, 20));
        Checkbox cbxV = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.visible", new Object[0]));
        cbxV.setBounds(new Box(0, 0, 75, 20));
        cbxV.setSelected(cte.copyVis);
        cbxV.setAction(() -> cbxV.setSelected(!cbxV.isSelected()));
        miscTr.addElement(cbxV);
        Checkbox cbxC = new Checkbox(this.gui, this.gui.i18nFormat("action.cpm.color", new Object[0]));
        cbxC.setBounds(new Box(80, 0, 75, 20));
        cbxC.setSelected(cte.copyColor);
        cbxC.setAction(() -> cbxC.setSelected(!cbxC.isSelected()));
        miscTr.addElement(cbxC);
        this.addElement(miscTr);
        Panel settings = new Panel(this.gui);
        settings.setBounds(new Box(5, 0, 290, 30));
        settings.addElement(new Label(this.gui, this.gui.i18nFormat("label.cpm.copyTransform.multiply", new Object[0])).setBounds(new Box(0, 0, 0, 0)));
        Spinner multiplySpinner = new Spinner(this.gui);
        multiplySpinner.setBounds(new Box(0, 10, 50, 20));
        multiplySpinner.setDp(2);
        multiplySpinner.setValue(cte.multiply);
        settings.addElement(multiplySpinner);
        Checkbox cbxA = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.anim_additive", new Object[0]));
        cbxA.setBounds(new Box(80, 10, 75, 20));
        cbxA.setSelected(cte.additive);
        cbxA.setAction(() -> cbxA.setSelected(!cbxA.isSelected()));
        settings.addElement(cbxA);
        this.addElement(settings);
        Button ok = new Button(this.gui, this.gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
            ActionBuilder ab = e.action("set", "label.cpm.copyTransformSettings");
            ab.updateValueOp(cte, cte.from, ((CTOrigin)picker.getSelected()).getElem(), (a, b) -> {
                a.from = b;
            });
            ab.updateValueOp(cte, cte.copyPX, pos[0], (a, b) -> {
                a.copyPX = b;
            });
            ab.updateValueOp(cte, cte.copyPY, pos[1], (a, b) -> {
                a.copyPY = b;
            });
            ab.updateValueOp(cte, cte.copyPZ, pos[2], (a, b) -> {
                a.copyPZ = b;
            });
            ab.updateValueOp(cte, cte.copyRX, rot[0], (a, b) -> {
                a.copyRX = b;
            });
            ab.updateValueOp(cte, cte.copyRY, rot[1], (a, b) -> {
                a.copyRY = b;
            });
            ab.updateValueOp(cte, cte.copyRZ, rot[2], (a, b) -> {
                a.copyRZ = b;
            });
            ab.updateValueOp(cte, cte.copySX, rsc[0], (a, b) -> {
                a.copySX = b;
            });
            ab.updateValueOp(cte, cte.copySY, rsc[1], (a, b) -> {
                a.copySY = b;
            });
            ab.updateValueOp(cte, cte.copySZ, rsc[2], (a, b) -> {
                a.copySZ = b;
            });
            ab.updateValueOp(cte, cte.copyVis, cbxV.isSelected(), (a, b) -> {
                a.copyVis = b;
            });
            ab.updateValueOp(cte, cte.copyColor, cbxC.isSelected(), (a, b) -> {
                a.copyColor = b;
            });
            ab.updateValueOp(cte, cte.additive, cbxA.isSelected(), (a, b) -> {
                a.additive = b;
            });
            ab.updateValueOp(cte, Float.valueOf(cte.multiply), Float.valueOf(multiplySpinner.getValue()), (a, b) -> {
                a.multiply = b.floatValue();
            });
            ab.execute();
            this.close();
        });
        ok.setBounds(new Box(5, 0, 60, 20));
        this.addElement(ok);
        layout.reflow();
    }

    private void walkElements(int d, List<ModelElement> elem, List<CTOrigin> elems) {
        for (ModelElement modelElement : elem) {
            elems.add(new CTOrigin(modelElement, d));
            this.walkElements(d + 1, modelElement.children, elems);
        }
    }

    private void createPanel(String name, boolean[] v) {
        Panel panel = new Panel(this.gui);
        panel.setBounds(new Box(0, 0, 170, 30));
        panel.addElement(new Label(this.gui, this.gui.i18nFormat("label.cpm." + name, new Object[0])).setBounds(new Box(5, 0, 100, 10)));
        Checkbox cbx = new Checkbox(this.gui, "X");
        Checkbox cby = new Checkbox(this.gui, "Y");
        Checkbox cbz = new Checkbox(this.gui, "Z");
        cbx.setSelected(v[0]);
        cby.setSelected(v[1]);
        cbz.setSelected(v[2]);
        cbx.setAction(() -> {
            v[0] = !v[0];
            cbx.setSelected(v[0]);
        });
        cby.setAction(() -> {
            v[1] = !v[1];
            cby.setSelected(v[1]);
        });
        cbz.setAction(() -> {
            v[2] = !v[2];
            cbz.setSelected(v[2]);
        });
        cbx.setBounds(new Box(5, 10, 50, 20));
        cby.setBounds(new Box(60, 10, 50, 20));
        cbz.setBounds(new Box(115, 10, 50, 20));
        panel.addElement(cbx);
        panel.addElement(cby);
        panel.addElement(cbz);
        this.addElement(panel);
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.copyTransformSettings", new Object[0]);
    }

    private class CTOrigin {
        private ModelElement elem;
        private int d;

        public CTOrigin(ModelElement elem, int d) {
            this.elem = elem;
            this.d = d;
        }

        public ModelElement getElem() {
            return this.elem;
        }

        public String toString() {
            return this.elem.getName();
        }

        private void draw(int x, int y, int w, int h, boolean hovered, boolean selected) {
            int c;
            int bg = ((CopyTransformSettingsPopup)CopyTransformSettingsPopup.this).gui.getColors().select_background;
            if (hovered) {
                bg = ((CopyTransformSettingsPopup)CopyTransformSettingsPopup.this).gui.getColors().popup_background;
            }
            if (selected || hovered) {
                CopyTransformSettingsPopup.this.gui.drawBox(x, y, w, h, bg);
            }
            if ((c = this.elem.textColor(CopyTransformSettingsPopup.this.gui)) == 0) {
                c = ((CopyTransformSettingsPopup)CopyTransformSettingsPopup.this).gui.getColors().button_text_color;
                if (hovered) {
                    c = ((CopyTransformSettingsPopup)CopyTransformSettingsPopup.this).gui.getColors().button_text_hover;
                }
            }
            CopyTransformSettingsPopup.this.gui.drawText(x + 3, y + h / 2 - 4, this.toString(), c);
        }

        private int width() {
            return CopyTransformSettingsPopup.this.gui.textWidth(this.elem.getName());
        }
    }
}

