/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.math.Rotation;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.text.I18n;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.project.JsonMap;
import java.util.HashMap;
import java.util.Map;

public class CopyTransformEffect {
    public final ModelElement to;
    public long storeID;
    public ModelElement from;
    public boolean copyPX;
    public boolean copyPY;
    public boolean copyPZ;
    public boolean copyRX;
    public boolean copyRY;
    public boolean copyRZ;
    public boolean copySX;
    public boolean copySY;
    public boolean copySZ;
    public boolean copyVis;
    public boolean copyColor;
    public boolean additive;
    public float multiply = 1.0f;

    public CopyTransformEffect(ModelElement to) {
        this.to = to;
    }

    public void load(JsonMap data) {
        this.storeID = data.getLong("storeID", -1L);
        this.copyPX = data.getBoolean("px", false);
        this.copyPY = data.getBoolean("py", false);
        this.copyPZ = data.getBoolean("pz", false);
        this.copyRX = data.getBoolean("rx", false);
        this.copyRY = data.getBoolean("ry", false);
        this.copyRZ = data.getBoolean("rz", false);
        this.copySX = data.getBoolean("sx", false);
        this.copySY = data.getBoolean("sy", false);
        this.copySZ = data.getBoolean("sz", false);
        this.copyVis = data.getBoolean("cv", false);
        this.copyColor = data.getBoolean("r", false);
        this.additive = data.getBoolean("additive", false);
        this.multiply = data.getFloat("multiply", 1.0f);
    }

    public short toShort() {
        short r = 0;
        if (this.copyPX) {
            r = (short)(r | 1);
        }
        if (this.copyPY) {
            r = (short)(r | 2);
        }
        if (this.copyPZ) {
            r = (short)(r | 4);
        }
        if (this.copyRX) {
            r = (short)(r | 8);
        }
        if (this.copyRY) {
            r = (short)(r | 0x10);
        }
        if (this.copyRZ) {
            r = (short)(r | 0x20);
        }
        if (this.copySX) {
            r = (short)(r | 0x40);
        }
        if (this.copySY) {
            r = (short)(r | 0x80);
        }
        if (this.copySZ) {
            r = (short)(r | 0x100);
        }
        if (this.copyVis) {
            r = (short)(r | 0x200);
        }
        if (this.copyColor) {
            r = (short)(r | 0x400);
        }
        if (this.additive) {
            r = (short)(r | 0x800);
        }
        if (Math.abs(this.multiply - 1.0f) > 0.01f) {
            r = (short)(r | 0x4000);
        }
        return r;
    }

    public void apply() {
        if (this.from != null) {
            Vec3f st;
            Rotation rt;
            Vec3f pt;
            Vec3f pf = this.from.rc.getTransformPosition();
            Rotation rf = this.from.rc.getTransformRotation();
            Vec3f sf = this.from.rc.getRenderScale();
            if (this.additive) {
                pt = Vec3f.ZERO;
                rt = Rotation.ZERO;
                st = Vec3f.ZERO;
            } else {
                pt = this.to.rc.getTransformPosition();
                rt = this.to.rc.getTransformRotation();
                st = this.to.rc.getRenderScale();
            }
            this.to.rc.setPosition(this.additive, this.copyPX ? pf.x * this.multiply : pt.x, this.copyPY ? pf.y * this.multiply : pt.y, this.copyPZ ? pf.z * this.multiply : pt.z);
            this.to.rc.setRotation(this.additive, this.copyRX ? rf.x * this.multiply : rt.x, this.copyRY ? rf.y * this.multiply : rt.y, this.copyRZ ? rf.z * this.multiply : rt.z);
            this.to.rc.setRenderScale(this.additive, this.copySX ? sf.x * this.multiply : st.x, this.copySY ? sf.y * this.multiply : st.y, this.copySZ ? sf.z * this.multiply : st.z);
            if (this.copyVis) {
                this.to.rc.setVisible(this.to.rc.doDisplay() && this.from.rc.isVisible());
            }
            if (this.copyColor) {
                this.to.rc.setColor(this.from.rc.getRGB());
            }
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (this.from != null) {
            r.put("storeID", this.from.storeID);
        }
        r.put("px", this.copyPX);
        r.put("py", this.copyPY);
        r.put("pz", this.copyPZ);
        r.put("rx", this.copyRX);
        r.put("ry", this.copyRY);
        r.put("rz", this.copyRZ);
        r.put("sx", this.copySX);
        r.put("sy", this.copySY);
        r.put("sz", this.copySZ);
        r.put("cv", this.copyVis);
        r.put("color", this.copyColor);
        r.put("additive", this.additive);
        r.put("multiply", Float.valueOf(this.multiply));
        return r;
    }

    public void load(Editor editor) {
        Editor.walkElements(editor.elements, elem -> {
            if (elem.storeID == this.storeID) {
                this.from = elem;
            }
        });
    }

    public String getTooltip(I18n gui) {
        StringBuilder sb = new StringBuilder();
        sb.append(gui.i18nFormat("label.cpm.copyTransform", new Object[0]));
        if (this.from != null) {
            sb.append("\\ ");
            sb.append(gui.i18nFormat("label.cpm.copyTransform.from", this.from.getElemName()));
        }
        boolean p = this.createXYZ(sb, gui.i18nFormat("label.cpm.position", new Object[0]), this.copyPX, this.copyPY, this.copyPZ);
        boolean r = this.createXYZ(sb, gui.i18nFormat("label.cpm.rotation", new Object[0]), this.copyRX, this.copyRY, this.copyRZ);
        boolean s = this.createXYZ(sb, gui.i18nFormat("label.cpm.scale", new Object[0]), this.copySX, this.copySY, this.copySZ);
        if (this.copyVis) {
            sb.append("\\  ");
            sb.append(gui.i18nFormat("label.cpm.visible", new Object[0]));
        }
        if (this.copyColor) {
            sb.append("\\  ");
            sb.append(gui.i18nFormat("action.cpm.color", new Object[0]));
        }
        if (this.additive) {
            sb.append("\\  ");
            sb.append(gui.i18nFormat("label.cpm.anim_additive", new Object[0]));
        }
        if (Math.abs(this.multiply - 1.0f) > 0.01f) {
            sb.append("\\  ");
            sb.append(gui.i18nFormat("tooltip.cpm.copyTransform.multiply", String.format("%.2f", Float.valueOf(this.multiply))));
        }
        if (!(p || r || s || this.copyVis || this.copyColor)) {
            sb.append("\\  ");
            sb.append(gui.i18nFormat("tooltip.cpm.noCopyTransforms", new Object[0]));
        }
        return sb.toString();
    }

    private boolean createXYZ(StringBuilder sb, String name, boolean x, boolean y, boolean z) {
        if (x || y || z) {
            sb.append("\\  ");
            sb.append(name);
            sb.append(": ");
            if (x) {
                sb.append('X');
            }
            if (y && x) {
                sb.append(", Y");
            } else if (y) {
                sb.append('Y');
            }
            if (z && (x || y)) {
                sb.append(", Z");
            } else if (z) {
                sb.append('Z');
            }
            return true;
        }
        return false;
    }

    public void setAll(boolean v) {
        this.copyPX = v;
        this.copyPY = v;
        this.copyPZ = v;
        this.copyRX = v;
        this.copyRY = v;
        this.copyRZ = v;
        this.copySX = v;
        this.copySY = v;
        this.copySZ = v;
        this.copyVis = v;
        this.copyColor = v;
    }
}

