/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.config;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpm.shared.config.ModConfig;

public class Keybind {
    public static final int CTRL = 2;
    public static final int SHIFT = 1;
    public static final int ALT = 4;
    private final String key;
    private final String defKey;
    private final int defMod;
    private final Key defKeyId;

    public Keybind(String key) {
        this(key, (KeyCodes c) -> 0, 0);
    }

    public Keybind(String key, Key defKeyId) {
        this(key, defKeyId, 0);
    }

    public Keybind(String key, String defKey) {
        this(key, defKey, 0);
    }

    public Keybind(String key, Key defKeyId, int defMod) {
        this.key = key;
        this.defKeyId = defKeyId;
        this.defKey = "";
        this.defMod = defMod;
    }

    public Keybind(String key, String defKey, int defMod) {
        this.key = key;
        this.defKey = defKey;
        this.defKeyId = c -> -1;
        this.defMod = defMod;
    }

    public boolean isPressed(IGui gui, KeyboardEvent evt) {
        if (evt.isConsumed()) {
            return false;
        }
        ConfigEntry ce = ModConfig.getCommonConfig().getEntry("keybinds");
        if (this.isPressed0(gui, ce, evt)) {
            int modKeys = ce.getInt(this.key + ".mod", this.defMod);
            if (modKeys < 1) {
                return true;
            }
            if ((modKeys & 1) != 0 && !gui.isShiftDown()) {
                return false;
            }
            if ((modKeys & 2) != 0 && !gui.isCtrlDown()) {
                return false;
            }
            return (modKeys & 4) == 0 || gui.isAltDown();
        }
        return false;
    }

    private boolean isPressed0(IGui gui, ConfigEntry ce, KeyboardEvent evt) {
        int id = ce.getInt(this.key, -1);
        if (id == -1) {
            String k = ce.getString(this.key, "");
            int def = this.defKeyId.get(gui.getKeyCodes());
            if (k.isEmpty()) {
                return def != -1 ? evt.matches(def) : evt.matches(this.defKey);
            }
            return evt.matches(k);
        }
        return evt.matches(id);
    }

    public int getMod() {
        return ModConfig.getCommonConfig().getEntry("keybinds").getInt(this.key + ".mod", this.defMod);
    }

    public void setKey(ConfigEntry config, KeyboardEvent evt, int mod) {
        ConfigEntry ce = config.getEntry("keybinds");
        if (evt.keyName != null && !evt.keyName.isEmpty()) {
            ce.setString(this.key, evt.keyName);
        } else {
            ce.setInt(this.key, evt.keyCode);
        }
        if (mod > 0) {
            ce.setInt(this.key + ".mod", mod);
        } else {
            ce.clearValue(this.key + ".mod");
        }
    }

    public void unbindKey(ConfigEntry config) {
        ConfigEntry ce = config.getEntry("keybinds");
        ce.setInt(this.key, 0);
        ce.clearValue(this.key + ".mod");
    }

    public void resetKey(ConfigEntry config) {
        ConfigEntry ce = config.getEntry("keybinds");
        ce.clearValue(this.key);
        ce.clearValue(this.key + ".mod");
    }

    public String getKeyName() {
        return "label.cpm.keybind." + this.key;
    }

    public String getSetKey(IGui gui) {
        return this.getSetKey(ModConfig.getCommonConfig(), gui);
    }

    public String formatTooltip(IGui gui, String info) {
        return gui.i18nFormat("tooltip.cpm.keybind", info, this.getSetKey(gui));
    }

    public String getSetKey(ConfigEntry ce, IGui gui) {
        String key = this.getSetKey0(ce = ce.getEntry("keybinds"), gui);
        if (key == null) {
            return gui.i18nFormat("button.cpm.keybindNone", new Object[0]);
        }
        int modKeys = ce.getInt(this.key + ".mod", this.defMod);
        if (modKeys < 1) {
            return key;
        }
        if ((modKeys & 4) != 0) {
            key = gui.i18nFormat("label.cpm.keybind.mod.alt", key);
        }
        if ((modKeys & 1) != 0) {
            key = gui.i18nFormat("label.cpm.keybind.mod.shift", key);
        }
        if ((modKeys & 2) != 0) {
            key = gui.i18nFormat("label.cpm.keybind.mod.ctrl", key);
        }
        return key;
    }

    private String getSetKey0(ConfigEntry ce, IGui gui) {
        int id = ce.getInt(this.key, -1);
        if (id == -1) {
            String k = ce.getString(this.key, "");
            int def = this.defKeyId.get(gui.getKeyCodes());
            if (k.isEmpty()) {
                return def != -1 ? (def == 0 ? null : gui.getKeyCodes().keyToString(gui, def)) : this.defKey;
            }
            return k;
        }
        if (id == 0) {
            return null;
        }
        return gui.getKeyCodes().keyToString(gui, id);
    }

    @FunctionalInterface
    public static interface Key {
        public int get(KeyCodes var1);
    }
}

