/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.api;

import com.tom.cpm.api.CPMPluginRegistry;
import com.tom.cpm.api.ClientApi;
import com.tom.cpm.api.CommonApi;
import com.tom.cpm.api.ICPMPlugin;
import java.util.ArrayList;
import java.util.List;

public class CPMApiManager
implements CPMPluginRegistry {
    private List<ICPMPlugin> plugins = new ArrayList<ICPMPlugin>();
    protected ClientApi client;
    protected CommonApi common;

    @Override
    public void register(ICPMPlugin plugin) {
        this.plugins.add(plugin);
    }

    public String getPluginStatus() {
        StringBuilder bb = new StringBuilder();
        bb.append("Loaded plugins: (");
        bb.append(this.plugins.size());
        bb.append(")\n");
        this.plugins.forEach(p -> {
            bb.append('\t');
            bb.append(p.getOwnerModId());
            bb.append('\n');
        });
        return bb.toString();
    }

    public ClientApi clientApi() {
        return this.client;
    }

    public CommonApi commonApi() {
        return this.common;
    }

    protected void initClient() {
        this.plugins.forEach(this.client::callInit);
    }

    protected void initCommon() {
        this.plugins.forEach(this.common::callInit);
    }

    public ClientApi.ApiBuilder buildClient() {
        return new ClientApi.ApiBuilder(this);
    }

    public CommonApi.ApiBuilder buildCommon() {
        return new CommonApi.ApiBuilder(this);
    }
}

