/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;

public class Util {
    public static <T> List<T> listFromTree(Consumer<Consumer<T>> tree) {
        ArrayList lst = new ArrayList();
        tree.accept(lst::add);
        return lst;
    }

    public static Map<String, Object> deepCopy(Map<String, Object> data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            map.put(e.getKey(), Util.deepCopy0(e.getValue()));
        }
        return map;
    }

    public static List<Object> deepCopy(List<Object> data) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : data) {
            list.add(Util.deepCopy0(object));
        }
        return list;
    }

    private static Object deepCopy0(Object data) {
        if (data instanceof Map) {
            return Util.deepCopy((Map)data);
        }
        if (data instanceof List) {
            return Util.deepCopy((List)data);
        }
        return data;
    }

    public static UUID uuidFromString(String input) {
        if (input.indexOf(45) != -1) {
            return UUID.fromString(input);
        }
        return UUID.fromString(input.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String hideIp(String ip) {
        ip = ip.replaceAll("[0-9]", "*");
        int cnt = 0;
        StringBuilder bb = new StringBuilder();
        for (int i = 0; i < ip.length(); ++i) {
            char c = ip.charAt(i);
            if (c == '.' || c == ':') {
                cnt = -1;
            }
            if (cnt++ > 1) {
                c = '*';
            }
            bb.append(c);
        }
        ip = bb.toString();
        return ip;
    }
}

