/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.math;

import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.Quaternion;
import com.tom.cpl.math.Vec2f;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VertexBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class TriangleBoundingBox {
    private List<Triangle> triangles = new ArrayList<Triangle>();
    private float depth = Float.NEGATIVE_INFINITY;
    private Vec2f hoverPointer = new Vec2f();
    private static final Vec3f NULL = new Vec3f(-1.0f, -1.0f, Float.NEGATIVE_INFINITY);
    private boolean noCull;

    private static void swap(Vec2f a, Vec2f b) {
        float x = a.x;
        float y = a.y;
        a.x = b.x;
        a.y = b.y;
        b.x = x;
        b.y = y;
    }

    private static void swap(Vec3f a, Vec3f b) {
        float x = a.x;
        float y = a.y;
        float z = a.z;
        a.x = b.x;
        a.y = b.y;
        a.z = b.z;
        b.x = x;
        b.y = y;
        b.z = z;
    }

    public void transform(Mat4f matr) {
        this.triangles.forEach(t -> t.transform(matr));
    }

    public void transform(Quaternion q) {
        Mat4f mat = new Mat4f();
        mat.setIdentity();
        mat.mul(q);
        this.triangles.forEach(t -> t.transform(mat));
    }

    public void finishTransform(int w, int h, Vec2i cursor) {
        this.triangles.forEach(t -> t.finishTransform(w, h));
        Vec3f f = this.triangles.stream().map(t -> t.isHovered(cursor)).max(Comparator.comparingDouble(v -> v.z)).orElse(NULL);
        if (Float.isInfinite(f.z)) {
            this.depth = Float.NEGATIVE_INFINITY;
        } else {
            this.depth = f.z;
            this.hoverPointer.x = f.x;
            this.hoverPointer.y = f.y;
        }
    }

    public float isHovered() {
        return this.depth;
    }

    public Vec2f getHoverPointer() {
        return this.hoverPointer;
    }

    public List<Triangle> getTriangles() {
        return this.triangles;
    }

    public static BoxBuilder builder() {
        return new BoxBuilder();
    }

    public static class BoxBuilder
    implements VertexBuffer {
        private Vertex current;
        private Vertex[] currentArray = new Vertex[4];
        private int nextV;
        private TriangleBoundingBox b = new TriangleBoundingBox();

        private BoxBuilder() {
            for (int i = 0; i < this.currentArray.length; ++i) {
                this.currentArray[i] = new Vertex();
            }
            this.current = this.currentArray[0];
            ++this.nextV;
        }

        @Override
        public VertexBuffer pos(float x, float y, float z) {
            this.current.x = x;
            this.current.y = y;
            this.current.z = z;
            return this;
        }

        @Override
        public VertexBuffer tex(float u, float v) {
            this.current.u = u;
            this.current.v = v;
            return this;
        }

        @Override
        public VertexBuffer color(float red, float green, float blue, float alpha) {
            return this;
        }

        @Override
        public VertexBuffer normal(float x, float y, float z) {
            return this;
        }

        @Override
        public void endVertex() {
            if (this.nextV > 3) {
                Vec3f v0 = new Vec3f(this.currentArray[0].x, this.currentArray[0].y, this.currentArray[0].z);
                Vec3f v1 = new Vec3f(this.currentArray[1].x, this.currentArray[1].y, this.currentArray[1].z);
                Vec3f v2 = new Vec3f(this.currentArray[2].x, this.currentArray[2].y, this.currentArray[2].z);
                Vec3f v3 = new Vec3f(this.currentArray[3].x, this.currentArray[3].y, this.currentArray[3].z);
                Vec2f t0 = new Vec2f(this.currentArray[0].u, this.currentArray[0].v);
                Vec2f t1 = new Vec2f(this.currentArray[1].u, this.currentArray[1].v);
                Vec2f t2 = new Vec2f(this.currentArray[2].u, this.currentArray[2].v);
                Vec2f t3 = new Vec2f(this.currentArray[3].u, this.currentArray[3].v);
                List<Triangle> list = this.b.triangles;
                TriangleBoundingBox triangleBoundingBox = this.b;
                Objects.requireNonNull(triangleBoundingBox);
                list.add(triangleBoundingBox.new Triangle(v0, v1, v2, t0, t1, t2));
                List<Triangle> list2 = this.b.triangles;
                TriangleBoundingBox triangleBoundingBox2 = this.b;
                Objects.requireNonNull(triangleBoundingBox2);
                list2.add(triangleBoundingBox2.new Triangle(v0, v2, v3, t0, t2, t3));
                this.nextV = 0;
            }
            this.current = this.currentArray[this.nextV++];
        }

        @Override
        public void finish() {
        }

        public TriangleBoundingBox build() {
            return this.build(false);
        }

        public TriangleBoundingBox build(boolean noCull) {
            this.b.noCull = noCull;
            return this.b;
        }

        private static class Vertex {
            private float x;
            private float y;
            private float z;
            private float u;
            private float v;

            private Vertex() {
            }
        }
    }

    public class Triangle {
        public Vec4f[] verts = new Vec4f[3];
        public Vec2f[] uvs;
        public boolean culled;

        public Triangle(Vec3f a, Vec3f b, Vec3f c, Vec2f aUV, Vec2f bUV, Vec2f cUV) {
            this.verts[0] = new Vec4f(a, 1.0f);
            this.verts[1] = new Vec4f(b, 1.0f);
            this.verts[2] = new Vec4f(c, 1.0f);
            this.uvs = new Vec2f[3];
            this.uvs[0] = aUV;
            this.uvs[1] = bUV;
            this.uvs[2] = cUV;
        }

        public void transform(Mat4f matr) {
            for (int i = 0; i < this.verts.length; ++i) {
                this.verts[i].transform(matr);
            }
        }

        public void finishTransform(int w, int h) {
            Vec3f line1 = new Vec3f();
            Vec3f line2 = new Vec3f();
            line1.x = this.verts[1].x - this.verts[0].x;
            line1.y = this.verts[1].y - this.verts[0].y;
            line1.z = this.verts[1].z - this.verts[0].z;
            line2.x = this.verts[2].x - this.verts[0].x;
            line2.y = this.verts[2].y - this.verts[0].y;
            line2.z = this.verts[2].z - this.verts[0].z;
            Vec3f normal = new Vec3f();
            normal.x = line1.y * line2.z - line1.z * line2.y;
            normal.y = line1.z * line2.x - line1.x * line2.z;
            normal.z = line1.x * line2.y - line1.y * line2.x;
            normal.normalize();
            double normalDot = normal.x * this.verts[0].x + normal.y * this.verts[0].y + normal.z * this.verts[0].z;
            if (normalDot > 0.0 && !TriangleBoundingBox.this.noCull) {
                this.culled = true;
                return;
            }
            for (int i = 0; i < this.verts.length; ++i) {
                Vec4f vec4f = this.verts[i];
                vec4f.x = (vec4f.x + 1.0f) * 0.5f * (float)w;
                vec4f.y = (-vec4f.y + 1.0f) * 0.5f * (float)h;
            }
        }

        public Vec3f isHovered(Vec2i s) {
            Vec3f tex_e;
            Vec3f tex_s;
            int bx;
            int ax;
            boolean s_ab;
            int as_x;
            int as_y;
            if (this.culled) {
                return NULL;
            }
            Vec2i a = new Vec2i(this.verts[0].x, this.verts[0].y);
            Vec2i b = new Vec2i(this.verts[1].x, this.verts[1].y);
            Vec2i c = new Vec2i(this.verts[2].x, this.verts[2].y);
            if ((c.x - a.x) * as_y - (c.y - a.y) * as_x > 0 == (s_ab = (b.x - a.x) * (as_y = s.y - a.y) - (b.y - a.y) * (as_x = s.x - a.x) > 0)) {
                return NULL;
            }
            if ((c.x - b.x) * (s.y - b.y) - (c.y - b.y) * (s.x - b.x) > 0 != s_ab) {
                return NULL;
            }
            Vec2f p1 = new Vec2f(this.verts[0]);
            Vec2f p2 = new Vec2f(this.verts[1]);
            Vec2f p3 = new Vec2f(this.verts[2]);
            Vec3f uv1 = new Vec3f(this.uvs[0], this.verts[0].z);
            Vec3f uv2 = new Vec3f(this.uvs[1], this.verts[1].z);
            Vec3f uv3 = new Vec3f(this.uvs[2], this.verts[2].z);
            if (p2.y < p1.y) {
                TriangleBoundingBox.swap(p1, p2);
                TriangleBoundingBox.swap(uv1, uv2);
            }
            if (p3.y < p1.y) {
                TriangleBoundingBox.swap(p1, p3);
                TriangleBoundingBox.swap(uv1, uv3);
            }
            if (p3.y < p2.y) {
                TriangleBoundingBox.swap(p3, p2);
                TriangleBoundingBox.swap(uv3, uv2);
            }
            float dy1 = p2.y - p1.y;
            float dx1 = p2.x - p1.x;
            float du1 = uv2.x - uv1.x;
            float dv1 = uv2.y - uv1.y;
            float dw1 = uv2.z - uv1.z;
            float dy2 = p3.y - p1.y;
            float dx2 = p3.x - p1.x;
            float du2 = uv3.x - uv1.x;
            float dv2 = uv3.y - uv1.y;
            float dw2 = uv3.z - uv1.z;
            float dax_step = 0.0f;
            float dbx_step = 0.0f;
            float du1_step = 0.0f;
            float dv1_step = 0.0f;
            float du2_step = 0.0f;
            float dv2_step = 0.0f;
            float dw1_step = 0.0f;
            float dw2_step = 0.0f;
            if (dy1 != 0.0f) {
                dax_step = dx1 / Math.abs(dy1);
            }
            if (dy2 != 0.0f) {
                dbx_step = dx2 / Math.abs(dy2);
            }
            if (dy1 != 0.0f) {
                du1_step = du1 / Math.abs(dy1);
            }
            if (dy1 != 0.0f) {
                dv1_step = dv1 / Math.abs(dy1);
            }
            if (dy1 != 0.0f) {
                dw1_step = dw1 / Math.abs(dy1);
            }
            if (dy2 != 0.0f) {
                du2_step = du2 / Math.abs(dy2);
            }
            if (dy2 != 0.0f) {
                dv2_step = dv2 / Math.abs(dy2);
            }
            if (dy2 != 0.0f) {
                dw2_step = dw2 / Math.abs(dy2);
            }
            if (dy1 != 0.0f && (float)s.y > p1.y - 1.0f && (float)s.y < p2.y + 1.0f) {
                ax = (int)(p1.x + ((float)s.y - p1.y) * dax_step);
                bx = (int)(p1.x + ((float)s.y - p1.y) * dbx_step);
                tex_s = new Vec3f(uv1.x + ((float)s.y - p1.y) * du1_step, uv1.y + ((float)s.y - p1.y) * dv1_step, uv1.z + ((float)s.y - p1.y) * dw1_step);
                tex_e = new Vec3f(uv1.x + ((float)s.y - p1.y) * du2_step, uv1.y + ((float)s.y - p1.y) * dv2_step, uv1.z + ((float)s.y - p1.y) * dw2_step);
                if (ax > bx) {
                    int v = ax;
                    ax = bx;
                    bx = v;
                    TriangleBoundingBox.swap(tex_s, tex_e);
                }
                float tstep = 1.0f / (float)(bx - ax);
                if (s.x > ax - 2 && s.x < bx + 2) {
                    float t = tstep * (float)(s.x - ax);
                    float tex_u = (1.0f - t) * tex_s.x + t * tex_e.x;
                    float tex_v = (1.0f - t) * tex_s.y + t * tex_e.y;
                    float tex_w = (1.0f - t) * tex_s.z + t * tex_e.z;
                    return new Vec3f(tex_u, tex_v, tex_w);
                }
            }
            dy1 = p3.y - p2.y;
            dx1 = p3.x - p2.x;
            du1 = uv3.x - uv2.x;
            dv1 = uv3.y - uv2.y;
            dw1 = uv3.z - uv2.z;
            if (dy1 != 0.0f) {
                dax_step = dx1 / Math.abs(dy1);
            }
            if (dy2 != 0.0f) {
                dbx_step = dx2 / Math.abs(dy2);
            }
            du1_step = 0.0f;
            dv1_step = 0.0f;
            dw1_step = 0.0f;
            if (dy1 != 0.0f) {
                du1_step = du1 / Math.abs(dy1);
            }
            if (dy1 != 0.0f) {
                dv1_step = dv1 / Math.abs(dy1);
            }
            if (dy1 != 0.0f) {
                dw1_step = dw1 / Math.abs(dy1);
            }
            if (dy1 != 0.0f && (float)s.y > p2.y - 1.0f && (float)s.y < p3.y + 1.0f) {
                ax = (int)(p2.x + ((float)s.y - p2.y) * dax_step);
                bx = (int)(p1.x + ((float)s.y - p1.y) * dbx_step);
                tex_s = new Vec3f(uv2.x + ((float)s.y - p2.y) * du1_step, uv2.y + ((float)s.y - p2.y) * dv1_step, uv2.z + ((float)s.y - p2.y) * dw1_step);
                tex_e = new Vec3f(uv1.x + ((float)s.y - p1.y) * du2_step, uv1.y + ((float)s.y - p1.y) * dv2_step, uv1.z + ((float)s.y - p1.y) * dw2_step);
                if (ax > bx) {
                    int v = ax;
                    ax = bx;
                    bx = v;
                    TriangleBoundingBox.swap(tex_s, tex_e);
                }
                float tstep = 1.0f / (float)(bx - ax);
                if (s.x > ax - 2 && s.x < bx + 2) {
                    float t = tstep * (float)(s.x - ax);
                    float tex_u = (1.0f - t) * tex_s.x + t * tex_e.x;
                    float tex_v = (1.0f - t) * tex_s.y + t * tex_e.y;
                    float tex_w = (1.0f - t) * tex_s.z + t * tex_e.z;
                    return new Vec3f(tex_u, tex_v, tex_w);
                }
            }
            return NULL;
        }
    }
}

