/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import java.util.HashMap;
import java.util.Map;

public class TabbedPanelManager
extends Panel {
    private Map<Panel, Button> buttons = new HashMap<Panel, Button>();

    public TabbedPanelManager(IGui gui) {
        super(gui);
    }

    public Button createTab(String name, Panel panel) {
        return this.createTab(name, panel, null);
    }

    public Button createTab(String name, Panel panel, Runnable onSelect) {
        boolean vis = this.elements.isEmpty();
        panel.setVisible(vis);
        this.addElement(panel);
        Button btn = new Button(this.gui, name, null);
        btn.setAction(() -> {
            this.elements.forEach(p -> p.setVisible(false));
            panel.setVisible(true);
            this.buttons.values().forEach(b -> b.setEnabled(true));
            btn.setEnabled(false);
            if (onSelect != null) {
                onSelect.run();
            }
        });
        btn.setEnabled(!vis);
        this.buttons.put(panel, btn);
        return btn;
    }

    public void removeTab(Panel panel) {
        this.elements.remove(panel);
        this.buttons.remove(panel);
        if (panel.isVisible()) {
            panel.setVisible(false);
            if (!this.elements.isEmpty()) {
                ((GuiElement)this.elements.get(0)).setVisible(true);
            }
        }
    }
}

