/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import java.util.List;

public class ListElement<T>
extends GuiElement {
    protected ListModel<T> model;
    protected List<T> elements;
    protected T selected;

    public ListElement(IGui gui, ListModel<T> model, List<T> elems) {
        super(gui);
        this.model = model;
        this.elements = elems;
    }

    @Override
    public void mouseClick(MouseEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        if (this.bounds.isInBounds(evt.x, evt.y)) {
            int yp = (evt.y - this.bounds.y) / 10;
            this.selected = yp >= 0 && yp < this.elements.size() ? this.elements.get(yp) : null;
            this.model.selected(this.selected);
            evt.consume();
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        for (int i = 0; i < this.elements.size(); ++i) {
            boolean hovered = false;
            T el = this.elements.get(i);
            if (event.isHovered(this.bounds) && event.isHovered(new Box(this.bounds.x, i * 10, this.bounds.w, 10))) {
                hovered = true;
                Tooltip tt = this.model.getTooltip(el);
                if (tt != null) {
                    tt.set();
                }
            }
            this.model.draw(this.gui, el, 0, i * 10, this.bounds.w, 10, hovered, el == this.selected);
        }
    }

    public Vec2i getSize() {
        int w = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            T el = this.elements.get(i);
            w = Math.max(w, this.model.getWidth(this.gui, el));
        }
        return new Vec2i(w + 10, this.elements.size() * 10);
    }

    public void setSelected(T selected) {
        this.selected = selected;
    }

    public T getSelected() {
        return this.selected;
    }

    public static interface ListModel<T> {
        public Tooltip getTooltip(T var1);

        public String getDisplay(T var1);

        public void selected(T var1);

        default public int getWidth(IGui gui, T el) {
            return gui.textWidth(this.getDisplay(el));
        }

        default public void draw(IGui gui, T el, int x, int y, int w, int h, boolean hovered, boolean selected) {
            if (selected) {
                gui.drawBox(x, y, w, h, gui.getColors().select_background);
            }
            int textColor = gui.getColors().button_text_color;
            if (hovered) {
                textColor = gui.getColors().button_text_hover;
            }
            gui.drawText(x + 3, y + h / 2 - 4, this.getDisplay(el), textColor);
        }
    }
}

