/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.command;

import com.tom.cpl.command.CommandHandler;
import com.tom.cpl.text.IText;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CommandCtx<S> {
    private S sender;
    public final CommandHandler<S> handler;
    private Map<String, Object> arguments = new HashMap<String, Object>();
    private Set<String> flagsSet = new HashSet<String>();
    private int result;
    private IText fail;

    public CommandCtx(S sender, CommandHandler<S> handler) {
        this.sender = sender;
        this.handler = handler;
    }

    public void success() {
        this.result = 1;
    }

    public void success(int count) {
        this.result = count;
    }

    public void sendSuccess(IText message) {
        this.handler.sendSuccess(this.sender, message);
    }

    public void fail(IText message) {
        this.fail = message;
    }

    public int getResult() {
        return this.result;
    }

    public void arg(String id, Object value) {
        this.arguments.put(id, value);
    }

    public boolean hasFlag(String id) {
        return this.flagsSet.contains(id);
    }

    public <T> T getArgument(String id) {
        return (T)this.arguments.get(id);
    }

    public IText getFail() {
        return this.fail;
    }
}

