/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.core.mixin;

import com.soytutta.mynethersdelight.common.registry.MNDItems;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.FireworkRocketRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireworkRocketRecipe.class})
public abstract class FireworkRocketRecipeMixin {
    @Inject(method={"matches"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMatches(CraftingContainer container, Level level, CallbackInfoReturnable<Boolean> cir) {
        boolean hasPaper = false;
        int powderCannonCount = 0;
        int GunpowderCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(Items.f_42516_)) {
                if (hasPaper) {
                    cir.setReturnValue((Object)false);
                    return;
                }
                hasPaper = true;
                continue;
            }
            if (stack.m_150930_(MNDItems.POWDER_CANNON.get())) {
                if (++powderCannonCount <= 3 || GunpowderCount >= 1) continue;
                cir.setReturnValue((Object)false);
                return;
            }
            if (stack.m_150930_(Items.f_42403_)) {
                if (++GunpowderCount <= 3) continue;
                cir.setReturnValue((Object)false);
                return;
            }
            if (stack.m_150930_(Items.f_42689_)) continue;
            cir.setReturnValue((Object)false);
            return;
        }
        cir.setReturnValue((Object)(hasPaper && (powderCannonCount >= 1 || GunpowderCount >= 1) ? 1 : 0));
    }

    @Inject(method={"assemble"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAssemble(CraftingContainer container, RegistryAccess registry, CallbackInfoReturnable<ItemStack> cir) {
        boolean hasGunpowder = false;
        int powderCannonCount = 0;
        int extraCount = 0;
        int flight = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!stack.m_41619_()) {
                if (stack.m_150930_(Items.f_42403_)) {
                    hasGunpowder = true;
                    ++flight;
                } else if (stack.m_150930_(MNDItems.POWDER_CANNON.get())) {
                    ++powderCannonCount;
                    if (flight < 3) {
                        ++flight;
                    }
                }
            }
            if (!hasGunpowder) continue;
            extraCount = powderCannonCount;
        }
        ItemStack result = new ItemStack((ItemLike)Items.f_42688_, 3 + extraCount);
        CompoundTag fireworksTag = result.m_41698_("Fireworks");
        ListTag explosions = new ListTag();
        for (int i = 0; i < container.m_6643_(); ++i) {
            CompoundTag explosionTag;
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !stack.m_150930_(Items.f_42689_) || (explosionTag = stack.m_41737_("Explosion")) == null) continue;
            explosions.add((Object)explosionTag);
        }
        fireworksTag.m_128344_("Flight", (byte)flight);
        if (!explosions.isEmpty()) {
            fireworksTag.m_128365_("Explosions", (Tag)explosions);
        }
        cir.setReturnValue((Object)result);
    }
}

