/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.lexiconfig.compat.configured;

import com.codinglitch.lexiconfig.Lexiconfig;
import com.codinglitch.lexiconfig.LexiconfigApi;
import com.codinglitch.lexiconfig.Library;
import com.codinglitch.lexiconfig.classes.LexiconData;
import com.codinglitch.lexiconfig.classes.LexiconEntryData;
import com.codinglitch.lexiconfig.compat.configured.LexiconfiguredEntry;
import com.codinglitch.lexiconfig.compat.configured.LexiconfiguredValue;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Consumer;

public class LexiconfiguredFile
implements IModConfig {
    public final Library library;
    public final LexiconData lexicon;

    public LexiconfiguredFile(Library library, LexiconData lexicon) {
        this.library = library;
        this.lexicon = lexicon;
    }

    public void update(IConfigEntry entry) {
        Set values = ConfigHelper.getChangedValues((IConfigEntry)entry);
        if (values.isEmpty()) {
            return;
        }
        for (IConfigValue value : values) {
            if (!(value instanceof LexiconfiguredValue)) continue;
            LexiconfiguredValue lexiconfiguredValue = (LexiconfiguredValue)value;
            lexiconfiguredValue.update();
        }
        Lexiconfig.publish();
    }

    public IConfigEntry getRoot() {
        try {
            Field field = this.getClass().getDeclaredField("lexicon");
            return new LexiconfiguredEntry<LexiconData>(new LexiconEntryData<LexiconData>(field, this, this.lexicon));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigType getType() {
        return switch (this.lexicon.getLocation()) {
            default -> throw new IncompatibleClassChangeError();
            case LexiconfigApi.Location.COMMON -> ConfigType.UNIVERSAL;
            case LexiconfigApi.Location.CLIENT -> ConfigType.CLIENT;
            case LexiconfigApi.Location.SERVER -> ConfigType.SERVER;
            case LexiconfigApi.Location.WORLD -> ConfigType.WORLD;
        };
    }

    public String getFileName() {
        return this.lexicon.getName() + this.lexicon.getExtension().file;
    }

    public String getModId() {
        return this.library.getName();
    }

    public void loadWorldConfig(Path path, Consumer<IModConfig> result) throws IOException {
    }
}

