/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.DebugBlockTypes;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.set.RockType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

public class StoneType
extends RockType {
    public final Block stone;

    protected StoneType(ResourceLocation id, Block stone) {
        super(id, stone);
        this.stone = stone;
        if (((Boolean)ClientConfigs.BLOCKTYPES_DEBUG.get()).booleanValue() && !this.isVanilla()) {
            DebugBlockTypes.appendToDebugFile((String)this.getTranslationKey());
        }
    }

    public String getTranslationKey() {
        return "stone_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        super.initializeChildrenBlocks();
    }

    @Override
    public ItemLike mainChild() {
        return this.stone;
    }

    @Override
    public Block bricksOrStone() {
        Block bricks = this.getBlockOfThis("bricks");
        return bricks != null ? bricks : this.stone;
    }

    public static class Finder
    implements BlockType.SetFinder<StoneType> {
        private final Map<String, ResourceLocation> childNames = new HashMap<String, ResourceLocation>();
        private final Supplier<Block> stoneFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> stone) {
            this.id = id;
            this.stoneFinder = stone;
        }

        public static Finder vanilla(String nameStone) {
            return Finder.simple("minecraft", nameStone, nameStone);
        }

        public static Finder simple(String modId, String nameStoneType, String nameStone) {
            return Finder.simple(new ResourceLocation(modId, nameStoneType), new ResourceLocation(modId, nameStone));
        }

        public static Finder simple(ResourceLocation nameStoneTYpe, ResourceLocation nameStone) {
            return new Finder(nameStoneTYpe, () -> (Block)BuiltInRegistries.f_256975_.m_7745_(nameStone));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, new ResourceLocation(this.id.m_135827_(), childName));
        }

        public void addChild(String childType, ResourceLocation childName) {
            this.childNames.put(childType, childName);
        }

        @ApiStatus.Internal
        public Optional<StoneType> get() {
            if (PlatHelper.isModLoaded((String)this.id.m_135827_())) {
                try {
                    Block stone = this.stoneFinder.get();
                    Block defaultKey = (Block)BuiltInRegistries.f_256975_.m_7745_(BuiltInRegistries.f_256975_.m_122315_());
                    if (stone != defaultKey && stone != null) {
                        StoneType stoneType = new StoneType(this.id, stone);
                        this.childNames.forEach((key, value) -> {
                            if (BuiltInRegistries.f_257033_.m_7804_(value)) {
                                stoneType.addChild((String)key, BuiltInRegistries.f_257033_.m_7745_(value));
                            } else if (BuiltInRegistries.f_256975_.m_7804_(value)) {
                                stoneType.addChild((String)key, BuiltInRegistries.f_256975_.m_7745_(value));
                            } else {
                                StoneZone.LOGGER.warn("Failed to get children for StoneType: {} - {}", (Object)this.id, key);
                            }
                        });
                        return Optional.of(stoneType);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StoneZone.LOGGER.warn("Failed to find custom stone type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

