/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api.set;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.DebugBlockTypes;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.stone_zone.StoneZone;
import net.mehvahdjukaar.stone_zone.api.set.RockType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

public class MudType
extends RockType {
    public final Block mud;

    protected MudType(ResourceLocation id, Block mud) {
        super(id, mud);
        this.mud = mud;
        if (((Boolean)ClientConfigs.BLOCKTYPES_DEBUG.get()).booleanValue() && !this.isVanilla()) {
            DebugBlockTypes.appendToDebugFile((String)this.getTranslationKey());
        }
    }

    public String getTranslationKey() {
        return "mud_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildrenBlocks() {
        super.initializeChildrenBlocks();
        this.addChild("packed", this.findRelatedEntry("packed", (Registry)BuiltInRegistries.f_256975_));
    }

    @Override
    public ItemLike mainChild() {
        return this.mud;
    }

    public static class Finder
    implements BlockType.SetFinder<MudType> {
        private final Map<String, ResourceLocation> childNames = new HashMap<String, ResourceLocation>();
        private final Supplier<Block> mudFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> mud) {
            this.id = id;
            this.mudFinder = mud;
        }

        public static Finder vanilla(String nameMud) {
            return Finder.simple("minecraft", nameMud, nameMud);
        }

        public static Finder simple(String modId, String nameMudType, String nameMud) {
            return Finder.simple(new ResourceLocation(modId, nameMudType), new ResourceLocation(modId, nameMud));
        }

        public static Finder simple(ResourceLocation nameMudTYpe, ResourceLocation nameMud) {
            return new Finder(nameMudTYpe, () -> (Block)BuiltInRegistries.f_256975_.m_7745_(nameMud));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, new ResourceLocation(this.id.m_135827_(), childName));
        }

        public void addChild(String childType, ResourceLocation childName) {
            this.childNames.put(childType, childName);
        }

        @ApiStatus.Internal
        public Optional<MudType> get() {
            if (PlatHelper.isModLoaded((String)this.id.m_135827_())) {
                try {
                    Block mud = this.mudFinder.get();
                    Block defaultKey = (Block)BuiltInRegistries.f_256975_.m_7745_(BuiltInRegistries.f_256975_.m_122315_());
                    if (mud != defaultKey && mud != null) {
                        MudType mudType = new MudType(this.id, mud);
                        this.childNames.forEach((key, value) -> {
                            if (BuiltInRegistries.f_257033_.m_7804_(value)) {
                                mudType.addChild((String)key, BuiltInRegistries.f_257033_.m_7745_(value));
                            } else if (BuiltInRegistries.f_256975_.m_7804_(value)) {
                                mudType.addChild((String)key, BuiltInRegistries.f_256975_.m_7745_(value));
                            } else {
                                StoneZone.LOGGER.warn("Failed to get children for MudType: {} - {}", (Object)this.id, key);
                            }
                        });
                        return Optional.of(mudType);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StoneZone.LOGGER.warn("Failed to find custom mud type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

