/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.misc.ModelConfiguration;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.mehvahdjukaar.stone_zone.misc.ModelUtils;
import net.mehvahdjukaar.stone_zone.misc.ResourceUtils;
import net.mehvahdjukaar.stone_zone.misc.TintConfiguration;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneZoneEntrySet<T extends BlockType, B extends Block>
extends SimpleEntrySet<T, B> {
    protected TintConfiguration tintConfiguration;

    protected StoneZoneEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<B> baseBlock, Supplier<T> baseType, @NotNull Supplier<ResourceKey<CreativeModeTab>> tab, TabAddMode tabMode, SimpleEntrySet.LootTableMode lootMode, @Nullable TriFunction<T, B, Item.Properties, Item> itemFactory, @Nullable SimpleEntrySet.ITileHolder tileFactory, @Nullable Object renderType, @Nullable @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable McMetaFile>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, TintConfiguration tintConfig, boolean copyTint, Predicate<T> condition, ModelConfiguration modelConfig) {
        super(type, name, prefix, blockSupplier, baseBlock, baseType, tab, tabMode, lootMode, itemFactory, tileFactory, renderType, paletteSupplier, extraTransform, mergedPalette, copyTint, condition, modelConfig);
        this.tintConfiguration = tintConfig;
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends Block> Builder<T, B> of(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    protected BlockTypeResTransformer<T> makeModelTransformer(SimpleModule module, ResourceManager manager) {
        String nameBaseStone = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.getModId(), (ResourceManager)manager).replaceWithTextureFromChild("minecraft:block/" + nameBaseStone, "stone").replaceWithTextureFromChild("minecraft:block/cobblestone", "cobblestone").replaceWithTextureFromChild("minecraft:block/" + nameBaseStone + "_bricks", "bricks").replaceWithTextureFromChild("minecraft:block/smooth_" + nameBaseStone, "smooth").replaceWithTextureFromChild("minecraft:block/smooth_" + nameBaseStone + "_slab_side", "smooth_slab").replaceWithTextureFromChild("minecraft:block/polished_" + nameBaseStone, "polished").replaceWithTextureFromChild("minecraft:block/mossy_" + nameBaseStone + "_bricks", "mossy_bricks").addModifier((s, blockId, blockType) -> {
            JsonObject jsonObject = GsonHelper.m_13864_((String)s);
            ModelUtils.addTintIndexToModelAndReplaceParent(new ResourceLocation("none"), jsonObject, module, nameBaseStone, this.tintConfiguration);
            return jsonObject.toString();
        }).andThen(super.makeModelTransformer(module, manager));
    }

    protected BlockTypeResTransformer<T> makeBlockStateTransformer(SimpleModule module, ResourceManager manager) {
        String nameBaseStone = ((BlockType)this.baseType.get()).getTypeName();
        return BlockTypeResTransformer.create((String)module.getModId(), (ResourceManager)manager).replaceWithTextureFromChild("minecraft:block/" + nameBaseStone, "stone").replaceWithTextureFromChild("minecraft:block/polished_" + nameBaseStone, "polished").addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/" + nameBaseStone, ResourceUtils.getChildModelId("stone", stoneType, blockId))).addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/" + nameBaseStone + "_bricks", ResourceUtils.getChildModelId("bricks", stoneType, blockId))).addModifier((s, blockId, stoneType) -> s.replace("minecraft:block/smooth_" + nameBaseStone, ResourceUtils.getChildModelId("smooth", stoneType, blockId))).andThen(super.makeBlockStateTransformer(module, manager));
    }

    public void generateModels(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        this.makeBlockStateTransformer(module, manager);
        this.makeModelTransformer(module, manager);
        super.generateModels(module, manager, sink);
    }

    public void generateTags(SimpleModule module, ResourceManager manager, ResourceSink sink) {
        super.generateTags(module, manager, sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"wardstone", (String)"architects_palette", (String)"wizard_blocks", (boolean)true, (boolean)false, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"seared_stone", (String)"tconstruct", (String)"seared_blocks", (boolean)true, (boolean)true, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"scorched_stone", (String)"tconstruct", (String)"scorched_blocks", (boolean)true, (boolean)true, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"sugilite", (String)"caverns_and_chasms", (String)"static_note_blocks", (boolean)true, (boolean)true, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"cassiterite", (String)"caverns_and_chasms", (String)"deflects_projectiles", (boolean)true, (boolean)false, (ResourceSink)sink);
        TagUtility.addTagToAllBlocks((Map)this.blocks, (String)"cassiterite", (String)"caverns_and_chasms", (String)"weaker_deflect_velocity", (boolean)true, (boolean)false, (ResourceSink)sink);
    }

    public static class Builder<T extends BlockType, B extends Block>
    extends SimpleEntrySet.Builder<T, B> {
        protected TintConfiguration tintConfig = TintConfiguration.EMPTY;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            super(type, name, prefix, baseType, baseBlock, blockFactory);
        }

        public Builder<T, B> createPaletteFromStone() {
            return (Builder)this.createPaletteFromChild("stone");
        }

        public Builder<T, B> createPaletteFromBricks() {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild("bricks") != null) {
                    return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)"bricks", null, (BlockType)blockType, (ResourceManager)manager);
                }
                return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)"stone", null, (BlockType)blockType, (ResourceManager)manager);
            });
            return this;
        }

        public Builder<T, B> createPaletteFromStoneChild(String childKey) {
            this.setPalette((blockType, manager) -> {
                if (blockType.getChild(childKey) != null) {
                    return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)childKey, null, (BlockType)blockType, (ResourceManager)manager);
                }
                return AbstractSimpleEntrySet.makePaletteFromChild(p -> {}, (String)"stone", null, (BlockType)blockType, (ResourceManager)manager);
            });
            return this;
        }

        public StoneZoneEntrySet<T, B> build() {
            if (this.tab == null && PlatHelper.isDev()) {
                throw new IllegalStateException("Tab for module " + this.name + " was null!");
            }
            this.copyParentTint();
            StoneZoneEntrySet e = new StoneZoneEntrySet(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.tabMode, this.lootMode, this.itemFactory, this.tileHolder, this.renderType, this.palette, this.extraModelTransform, this.useMergedPalette, this.tintConfig, this.copyTint, this.condition, this.modelConfig);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }

        public Builder<T, B> excludeMultipleTextureFromTinting(ResourceLocation parentId, String ... textureKeys) {
            if (this.tintConfig == TintConfiguration.EMPTY) {
                this.tintConfig = TintConfiguration.createNew();
            }
            this.tintConfig.addParentAndTextureValues(parentId, textureKeys);
            return this;
        }

        public Builder<T, B> excludeTextureFromTinting(String ... textureKeys) {
            if (this.tintConfig == TintConfiguration.EMPTY) {
                this.tintConfig = TintConfiguration.createNew();
            }
            this.tintConfig.addTextureValues(textureKeys);
            return this;
        }
    }
}

