/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.belt;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.api.events.leveling.ExperienceAddEvent;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class LeatherBeltItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("slots").requiredPoints(2).stat(StatData.builder("charm").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.VILLAGE).build()).build();
    }

    @Override
    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return RelicSlotModifier.builder().entry((Pair<String, Integer>)Pair.of((Object)"charm", (Object)((int)Math.round(this.getAbilityValue(stack, "slots", "charm"))))).build();
    }

    @SubscribeEvent
    public static void onExperienceAdded(ExperienceAddEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack sourceStack = event.getStack();
        if (entity == null || sourceStack.m_41720_() == ItemRegistry.LEATHER_BELT.get()) {
            return;
        }
        if (sourceStack.m_204131_().map(tag -> tag.f_203868_().m_135815_()).anyMatch(tag -> tag.equals("charm"))) {
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.LEATHER_BELT.get());
            Item item = stack.m_41720_();
            if (!(item instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            relic.addExperience(entity, stack, 1);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition bone = mesh.m_171576_().m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, 9.0f, -2.5f, 9.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        bone.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-2.05f, -1.55f, -0.675f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)-2.5f, (float)-0.1516f, (float)0.0512f, (float)-0.0859f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }
}

