/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.forge;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.forge.util.BlockRendererImpl;
import fzzyhmstrs.emi_loot.server.condition.BlownUpByCreeperLootCondition;
import fzzyhmstrs.emi_loot.server.condition.KilledByWitherLootCondition;
import fzzyhmstrs.emi_loot.server.condition.MobSpawnedWithLootCondition;
import fzzyhmstrs.emi_loot.server.function.OminousBannerLootFunction;
import fzzyhmstrs.emi_loot.server.function.SetAnyDamageLootFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;

@Mod(value="emi_loot")
public class EMILootForge {
    public static final DeferredRegister<LootItemConditionType> LOOT_CONDITION_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"lootify");
    public static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTION_TYPES = DeferredRegister.create((ResourceKey)Registries.f_257015_, (String)"lootify");

    public EMILootForge() {
        IEventBus MOD_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        LOOT_CONDITION_TYPES.register(MOD_BUS);
        LOOT_FUNCTION_TYPES.register(MOD_BUS);
        if (FMLLoader.getDist().isClient()) {
            MinecraftForge.EVENT_BUS.addListener(BlockRendererImpl::onClientTick);
        }
        EMILoot.onInitialize();
    }

    static {
        EMILoot.WITHER_KILL = LOOT_CONDITION_TYPES.register("wither_kill", () -> new LootItemConditionType((Serializer)new KilledByWitherLootCondition.Serializer()));
        EMILoot.SPAWNS_WITH = LOOT_CONDITION_TYPES.register("spawns_with", () -> new LootItemConditionType((Serializer)new MobSpawnedWithLootCondition.Serializer()));
        EMILoot.CREEPER = LOOT_CONDITION_TYPES.register("creeper", () -> new LootItemConditionType((Serializer)new BlownUpByCreeperLootCondition.Serializer()));
        EMILoot.SET_ANY_DAMAGE = LOOT_FUNCTION_TYPES.register("set_any_damage", () -> new LootItemFunctionType((Serializer)new SetAnyDamageLootFunction.Serializer()));
        EMILoot.OMINOUS_BANNER = LOOT_FUNCTION_TYPES.register("ominous_banner", () -> new LootItemFunctionType((Serializer)new OminousBannerLootFunction.Serializer()));
    }
}

