/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.reg;

import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.items.AzaleaFlowersItem;
import com.ordana.immersive_weathering.items.EnchantedGoldenMossClumpItem;
import com.ordana.immersive_weathering.items.FlowerCrownItem;
import com.ordana.immersive_weathering.items.FrostItem;
import com.ordana.immersive_weathering.items.IceSickleItem;
import com.ordana.immersive_weathering.items.IcicleItem;
import com.ordana.immersive_weathering.items.LeafPileBlockItem;
import com.ordana.immersive_weathering.items.MossClumpItem;
import com.ordana.immersive_weathering.items.ThinIceItem;
import com.ordana.immersive_weathering.items.materials.FlowerCrownMaterial;
import com.ordana.immersive_weathering.items.materials.IcicleToolMaterial;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModFoods;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ModItems {
    public static final Supplier<BlockItem> ICICLE = ModItems.regItem("icicle", () -> new IcicleItem(ModBlocks.ICICLE.get(), new Item.Properties().m_41489_(ModFoods.ICICLE)));
    public static final Map<LeavesType, BlockItem> LEAF_PILES = new LinkedHashMap<LeavesType, BlockItem>();
    public static final Supplier<BlockItem> AZALEA_FLOWER_PILE = ModItems.regLeafPile("azalea_flower_pile", ModBlocks.AZALEA_FLOWER_PILE);
    public static final Supplier<Item> STONE_BRICK = ModItems.regItem("stone_brick", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> PRISMARINE_BRICK = ModItems.regItem("prismarine_brick", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> END_STONE_BRICK = ModItems.regItem("end_stone_brick", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> BLACKSTONE_BRICK = ModItems.regItem("blackstone_brick", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> DEEPSLATE_BRICK = ModItems.regItem("deepslate_brick", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> DEEPSLATE_TILE = ModItems.regItem("deepslate_tile", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> MORTAR = ModItems.regItem("mortar", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> AZALEA_FLOWERS = ModItems.regItem("azalea_flowers", () -> new AzaleaFlowersItem(new Item.Properties().m_41489_(ModFoods.AZALEA_FLOWER)));
    public static final Supplier<Item> FLOWER_CROWN = ModItems.regItem("flower_crown", () -> new FlowerCrownItem(FlowerCrownMaterial.INSTANCE, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final Supplier<Item> MOSS_CLUMP = ModItems.regItem("moss_clump", () -> new MossClumpItem(ModBlocks.MOSS.get(), new Item.Properties().m_41489_(ModFoods.MOSS_CLUMP)));
    public static final Supplier<Item> GOLDEN_MOSS_CLUMP = ModItems.regItem("golden_moss_clump", () -> new Item(new Item.Properties().m_41489_(ModFoods.GOLDEN_MOSS_CLUMP)));
    public static final Supplier<Item> ENCHANTED_GOLDEN_MOSS_CLUMP = ModItems.regItem("enchanted_golden_moss_clump", () -> new EnchantedGoldenMossClumpItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41489_(ModFoods.ENCHANTED_GOLDEN_MOSS_CLUMP)));
    public static final Map<WoodType, Item> BARK = new LinkedHashMap<WoodType, Item>();
    public static final Supplier<Item> TALLOW = ModItems.regItem("tallow", () -> new HoneycombItem(new Item.Properties()));
    public static final Supplier<Item> STEEL_WOOL = ModItems.regItem("steel_wool", () -> new Item(new Item.Properties().m_41499_(128)));
    public static final Supplier<Item> ICE_SICKLE = ModItems.regItem("ice_sickle", () -> new IceSickleItem(IcicleToolMaterial.INSTANCE, 5, -1.0f, new Item.Properties().m_41489_(ModFoods.ICICLE)));
    public static final Supplier<Item> THIN_ICE_ITEM = ModItems.regItem("thin_ice", () -> new ThinIceItem(ModBlocks.THIN_ICE.get(), new Item.Properties()));
    public static final Supplier<Item> FROST_ITEM = ModItems.regItem("frost", () -> new FrostItem(ModBlocks.FROST.get(), new Item.Properties()));
    public static final Supplier<Item> FIRE = ModItems.regItem("fire", () -> new BlockItem(Blocks.f_50083_, new Item.Properties().m_41487_(1)));
    public static final Supplier<Item> SOUL_FIRE = ModItems.regItem("soul_fire", () -> new BlockItem(Blocks.f_50084_, new Item.Properties().m_41487_(1)));

    public static void init() {
        BlockSetAPI.addDynamicItemRegistration(ModItems::registerLeafPilesItems, LeavesType.class);
        BlockSetAPI.addDynamicItemRegistration(ModItems::registerBark, WoodType.class);
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> itemSup) {
        return RegHelper.registerItem((ResourceLocation)ImmersiveWeathering.res(name), itemSup);
    }

    private static Supplier<BlockItem> regLeafPile(String name, Supplier<LeafPileBlock> oakLeafPile) {
        return ModItems.regItem(name, () -> new LeafPileBlockItem((Block)oakLeafPile.get(), new Item.Properties()));
    }

    private static void registerBark(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (WoodType type : woodTypes) {
            String name = !type.canBurn() ? type.getVariantId("scales", false) : type.getVariantId("bark", false);
            WoodBasedItem item = new WoodBasedItem(new Item.Properties(), type, 200);
            event.register(ImmersiveWeathering.res(name), (Object)item);
            BARK.put(type, (Item)item);
            type.addChild("immersive_weathering:bark", (Object)item);
        }
    }

    private static void registerLeafPilesItems(Registrator<Item> event, Collection<LeavesType> leavesTypes) {
        for (LeavesType type : leavesTypes) {
            LeafPileBlock b = ModBlocks.LEAF_PILES.get(type);
            LeafPileBlockItem i = new LeafPileBlockItem((Block)b, new Item.Properties());
            event.register(Utils.getID((Block)b), (Object)i);
            LEAF_PILES.put(type, i);
        }
    }
}

