/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.blocks.sandy.Sandy;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.TemperatureManager;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SandGrowth
extends BuiltinBlockGrowth {
    protected SandGrowth(String name, @Nullable HolderSet<Block> owners, List<TickSource> sources, float chance) {
        super(name, owners, sources, chance);
    }

    @Nullable
    public Iterable<Block> getOwners() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        ((HolderSet.Named)BuiltInRegistries.f_256975_.m_203431_(ModTags.SANDABLE).get()).m_203614_().forEach(h -> blocks.add((Block)h.m_203334_()));
        ((HolderSet.Named)BuiltInRegistries.f_256975_.m_203431_(ModTags.SANDY).get()).m_203614_().forEach(h -> blocks.add((Block)h.m_203334_()));
        return blocks;
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState state, ServerLevel level, Supplier<Holder<Biome>> biome) {
        if (this.growthChance != 1.0f && !(level.f_46441_.m_188501_() < this.growthChance)) {
            return;
        }
        if (TemperatureManager.hasSandstorm(level, pos)) {
            Optional<BlockState> sandyBlock = Sandy.getSandy(state);
            RandomSource random = level.f_46441_;
            int rand = random.m_188503_(10);
            if (state.m_204336_(ModTags.SANDY) && (Integer)state.m_61143_((Property)ModBlockProperties.SANDINESS) == 0 && Sandy.isRandomSandyPos(pos)) {
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)ModBlockProperties.SANDINESS, (Comparable)Integer.valueOf(1))).m_61124_((Property)ModBlockProperties.SAND_AGE, (Comparable)Integer.valueOf(rand)));
            } else if (sandyBlock.isPresent()) {
                BlockPos downPos = pos.m_7495_();
                BlockState downBlock = level.m_8055_(downPos);
                if (WeatheringHelper.isRandomWeatheringPos(downPos)) {
                    Optional<BlockState> sandyBlock2 = Sandy.getSandy(downBlock);
                    if (sandyBlock2.isPresent()) {
                        level.m_46597_(pos, (BlockState)sandyBlock.get().m_61124_((Property)ModBlockProperties.SANDINESS, (Comparable)Integer.valueOf(1)));
                        level.m_46597_(pos.m_7495_(), (BlockState)sandyBlock2.get().m_61124_((Property)ModBlockProperties.SANDINESS, (Comparable)Integer.valueOf(0)));
                        level.m_46597_(pos.m_7494_(), ModBlocks.SAND_LAYER_BLOCK.get().m_49966_());
                    }
                } else {
                    level.m_46597_(pos, sandyBlock.get());
                }
            }
        }
    }
}

