/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.nephrite;

import com.ordana.spelunkery.blocks.entity.CarvedNephriteBlockEntity;
import com.ordana.spelunkery.blocks.entity.NephriteFountainEntity;
import com.ordana.spelunkery.reg.ModBlockProperties;
import com.ordana.spelunkery.reg.ModEntities;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NephriteFountainBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty OPEN = ModBlockProperties.OPEN;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)6.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)6.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)6.0, (double)14.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)6.0, (double)14.0);

    public NephriteFountainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directions;
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
        Level levelReader = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Direction[] var6 = directions = context.m_6232_();
        int var7 = directions.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            Direction direction2;
            Direction direction = var6[var8];
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(direction2 = direction.m_122424_()))).m_60710_((LevelReader)levelReader, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean bl;
        if (!level.f_46443_ && (bl = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != level.m_276867_(pos)) {
            if (bl) {
                level.m_186460_(pos, (Block)this, 1);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)OPEN), 2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        CarvedNephriteBlockEntity neighborTile;
        BlockEntity blockEntity;
        ItemStack stack = player.m_21120_(hand);
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (stack.m_150930_(Items.f_42590_) && (blockEntity = level.m_7702_(pos.m_121945_(dir.m_122424_()))) instanceof CarvedNephriteBlockEntity && (neighborTile = (CarvedNephriteBlockEntity)blockEntity).getCharge() >= 7 && level instanceof ServerLevel && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)OPEN), 2);
            level.m_186460_(pos, (Block)this, 4);
            neighborTile.setCharge(neighborTile.getCharge() - 7);
            level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
            level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (stack.m_41613_() > 1) {
                itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42612_.m_7968_());
                player.m_21008_(hand, itemStack2);
            } else {
                itemStack2 = new ItemStack((ItemLike)Items.f_42612_);
                if (!player.m_150109_().m_36054_(itemStack2)) {
                    player.m_36176_(itemStack2, false);
                }
                stack.m_41774_(1);
            }
            CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, OPEN});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> EAST_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.NORTH -> NORTH_AABB;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = level.m_8055_(blockPos);
        return direction.m_122434_().m_122479_() && blockState.m_60783_((BlockGetter)level, blockPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new NephriteFountainEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.f_46443_) {
            return NephriteFountainBlock.m_152132_(blockEntityType, ModEntities.NEPHRITE_FOUNTAIN.get(), NephriteFountainEntity::tickBlock);
        }
        return super.m_142354_(level, state, blockEntityType);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext c;
        Entity e;
        if (context instanceof EntityCollisionContext && (e = (c = (EntityCollisionContext)context).m_193113_()) instanceof ExperienceOrb) {
            return Shapes.m_83040_();
        }
        return this.m_5940_(state, level, pos, context);
    }
}

