/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks;

import com.ordana.spelunkery.reg.ModBlockProperties;
import com.ordana.spelunkery.reg.ModBlocks;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ChannelBlock
extends Block {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty SOUTH;
    public static final BooleanProperty EAST;
    public static final BooleanProperty WEST;
    public static final BooleanProperty SUPPORTED;
    protected static final VoxelShape SHAPE_N;
    protected static final VoxelShape SHAPE_E;
    protected static final VoxelShape SHAPE_S;
    protected static final VoxelShape SHAPE_W;
    protected static final VoxelShape SHAPE_NE;
    protected static final VoxelShape SHAPE_SE;
    protected static final VoxelShape SHAPE_NW;
    protected static final VoxelShape SHAPE_SW;
    protected static final VoxelShape SHAPE_EW;
    protected static final VoxelShape SHAPE_NS;
    protected static final VoxelShape SHAPE_NES;
    protected static final VoxelShape SHAPE_ESW;
    protected static final VoxelShape SHAPE_SWN;
    protected static final VoxelShape SHAPE_WNE;
    protected static final VoxelShape SHAPE_NESW;
    protected static final VoxelShape SHAPE_LEGS;
    protected static final VoxelShape SHAPE_BASE;
    protected static final VoxelShape SHAPE_NONE;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION;

    public ChannelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SUPPORTED, (Comparable)Boolean.valueOf(false)));
    }

    @PlatformOnly(value={"forge"})
    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.m_60713_(ModBlocks.WOODEN_CHANNEL.get());
    }

    @PlatformOnly(value={"forge"})
    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.m_60713_(ModBlocks.WOODEN_CHANNEL.get()) ? 20 : 0;
    }

    @PlatformOnly(value={"forge"})
    public int getFireSpread(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.m_60713_(ModBlocks.WOODEN_CHANNEL.get()) ? 5 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SUPPORTED, NORTH, EAST, SOUTH, WEST});
    }

    public boolean checkNeighborsForChannel(BlockPos pos, LevelAccessor level, Direction dir) {
        return level.m_8055_(pos.m_121945_(dir)).m_60734_() instanceof ChannelBlock && level.m_8055_(pos.m_121945_(dir.m_122424_())).m_60734_() instanceof ChannelBlock;
    }

    public boolean shouldHaveLegs(BlockGetter level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        Block block = belowState.m_60734_();
        return belowState.m_60783_(level, pos, Direction.UP) || block instanceof ChannelBlock || block instanceof HopperBlock;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean bl = this.shouldHaveLegs((BlockGetter)level, pos);
        if (this.checkNeighborsForChannel(pos, (LevelAccessor)level, Direction.NORTH) || this.checkNeighborsForChannel(pos, (LevelAccessor)level, Direction.WEST)) {
            bl = false;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SUPPORTED, (Comparable)Boolean.valueOf(bl)), 3);
        super.m_213897_(state, level, pos, random);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level blockGetter = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean bl = this.shouldHaveLegs((BlockGetter)blockGetter, pos);
        if (this.checkNeighborsForChannel(pos, (LevelAccessor)context.m_43725_(), Direction.NORTH) || this.checkNeighborsForChannel(pos, (LevelAccessor)context.m_43725_(), Direction.WEST)) {
            bl = false;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(!(blockGetter.m_8055_(pos.m_122012_()).m_60734_() instanceof ChannelBlock)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(!(blockGetter.m_8055_(pos.m_122029_()).m_60734_() instanceof ChannelBlock)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(!(blockGetter.m_8055_(pos.m_122019_()).m_60734_() instanceof ChannelBlock)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(!(blockGetter.m_8055_(pos.m_122024_()).m_60734_() instanceof ChannelBlock)))).m_61124_((Property)SUPPORTED, (Comparable)Boolean.valueOf(bl));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        level.m_186460_(pos, (Block)this, 1);
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.m_186460_(pos, (Block)this, 1);
        boolean bl = this.shouldHaveLegs((BlockGetter)level, pos);
        if (this.checkNeighborsForChannel(pos, level, Direction.NORTH) || this.checkNeighborsForChannel(pos, level, Direction.WEST)) {
            bl = false;
        }
        state.m_61124_((Property)SUPPORTED, (Comparable)Boolean.valueOf(bl));
        return neighborState.m_60734_() instanceof ChannelBlock && direction != Direction.UP && direction != Direction.DOWN ? (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(false)) : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BooleanProperty propDir;
        boolean tool;
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        Direction dir = hit.m_82434_();
        boolean stone = state.m_60713_(ModBlocks.STONE_CHANNEL.get());
        boolean bl = tool = stone ? itemStack.m_204117_(ItemTags.f_271360_) : itemStack.m_204117_(ItemTags.f_271207_);
        if (dir == Direction.UP || dir == Direction.DOWN || !tool) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        Boolean check = (Boolean)state.m_61143_((Property)(propDir = PROPERTY_BY_DIRECTION.get(dir)));
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)propDir, (Comparable)Boolean.valueOf(check == false)), 3);
        if (!stone) {
            level.m_5594_(null, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.m_5594_(null, pos, check.booleanValue() ? (stone ? SoundEvents.f_12442_ : SoundEvents.f_12630_) : (stone ? SoundEvents.f_12447_ : SoundEvents.f_12635_), SoundSource.BLOCKS, 1.0f, 1.0f);
        ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_49966_()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
        if (!level.m_6425_(pos.m_121945_(dir).m_7494_()).m_192917_(Fluids.f_76191_)) {
            level.m_7731_(pos.m_121945_(dir).m_7494_(), Blocks.f_50016_.m_49966_(), 3);
        }
        if (!player.m_7500_()) {
            itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Boolean north = (Boolean)state.m_61143_((Property)NORTH);
        Boolean south = (Boolean)state.m_61143_((Property)SOUTH);
        Boolean east = (Boolean)state.m_61143_((Property)EAST);
        Boolean west = (Boolean)state.m_61143_((Property)WEST);
        VoxelShape model = SHAPE_NONE;
        if (north.booleanValue() && south.booleanValue() && east.booleanValue() && west.booleanValue()) {
            return SHAPE_NESW;
        }
        if (north.booleanValue()) {
            model = SHAPE_N;
            if (east.booleanValue()) {
                model = SHAPE_NE;
                if (west.booleanValue()) {
                    return SHAPE_WNE;
                }
            }
            if (west.booleanValue()) {
                model = SHAPE_NW;
                if (south.booleanValue()) {
                    return SHAPE_SWN;
                }
            }
            if (south.booleanValue()) {
                model = SHAPE_NS;
                if (east.booleanValue()) {
                    return SHAPE_NES;
                }
            }
        } else if (east.booleanValue()) {
            model = SHAPE_E;
            if (south.booleanValue()) {
                model = SHAPE_SE;
                if (west.booleanValue()) {
                    return SHAPE_ESW;
                }
            } else if (west.booleanValue()) {
                return SHAPE_EW;
            }
        } else if (south.booleanValue()) {
            model = SHAPE_S;
            if (west.booleanValue()) {
                return SHAPE_SW;
            }
        } else if (west.booleanValue()) {
            return SHAPE_W;
        }
        return model;
    }

    static {
        EAST = PipeBlock.f_55149_;
        SOUTH = PipeBlock.f_55150_;
        WEST = PipeBlock.f_55151_;
        SUPPORTED = ModBlockProperties.SUPPORTED;
        PROPERTY_BY_DIRECTION = PipeBlock.f_55154_;
        SHAPE_BASE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
        SHAPE_LEGS = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-2.0, (double)12.0, (double)-2.0, (double)0.0, (double)22.0, (double)0.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-2.0, (double)12.0, (double)16.0, (double)0.0, (double)22.0, (double)18.0), Block.m_49796_((double)16.0, (double)12.0, (double)-2.0, (double)18.0, (double)22.0, (double)0.0), Block.m_49796_((double)16.0, (double)12.0, (double)16.0, (double)18.0, (double)22.0, (double)18.0)});
        SHAPE_NONE = Shapes.m_83110_((VoxelShape)SHAPE_LEGS, (VoxelShape)SHAPE_BASE);
        SHAPE_N = Shapes.m_83124_((VoxelShape)SHAPE_LEGS, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, Block.m_49796_((double)0.0, (double)12.0, (double)-2.0, (double)16.0, (double)22.0, (double)0.0)});
        SHAPE_E = Shapes.m_83124_((VoxelShape)SHAPE_LEGS, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, Block.m_49796_((double)16.0, (double)12.0, (double)0.0, (double)18.0, (double)22.0, (double)16.0)});
        SHAPE_S = Shapes.m_83124_((VoxelShape)SHAPE_LEGS, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, Block.m_49796_((double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)22.0, (double)18.0)});
        SHAPE_W = Shapes.m_83124_((VoxelShape)SHAPE_LEGS, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, Block.m_49796_((double)-2.0, (double)12.0, (double)0.0, (double)0.0, (double)22.0, (double)16.0)});
        SHAPE_NE = Shapes.m_83110_((VoxelShape)SHAPE_N, (VoxelShape)SHAPE_E);
        SHAPE_SE = Shapes.m_83110_((VoxelShape)SHAPE_S, (VoxelShape)SHAPE_E);
        SHAPE_NW = Shapes.m_83110_((VoxelShape)SHAPE_N, (VoxelShape)SHAPE_W);
        SHAPE_SW = Shapes.m_83110_((VoxelShape)SHAPE_S, (VoxelShape)SHAPE_W);
        SHAPE_EW = Shapes.m_83110_((VoxelShape)SHAPE_E, (VoxelShape)SHAPE_W);
        SHAPE_NS = Shapes.m_83110_((VoxelShape)SHAPE_N, (VoxelShape)SHAPE_S);
        SHAPE_NES = Shapes.m_83124_((VoxelShape)SHAPE_N, (VoxelShape[])new VoxelShape[]{SHAPE_E, SHAPE_S});
        SHAPE_ESW = Shapes.m_83124_((VoxelShape)SHAPE_E, (VoxelShape[])new VoxelShape[]{SHAPE_S, SHAPE_W});
        SHAPE_SWN = Shapes.m_83124_((VoxelShape)SHAPE_S, (VoxelShape[])new VoxelShape[]{SHAPE_W, SHAPE_N});
        SHAPE_WNE = Shapes.m_83124_((VoxelShape)SHAPE_W, (VoxelShape[])new VoxelShape[]{SHAPE_N, SHAPE_E});
        SHAPE_NESW = Shapes.m_83124_((VoxelShape)SHAPE_N, (VoxelShape[])new VoxelShape[]{SHAPE_E, SHAPE_S, SHAPE_W});
    }
}

