/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create;

import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BlackboardItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CreateCompat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlackboardDisplayTarget
extends DisplayTarget {
    private static final Pattern PATTERN = Pattern.compile("\\((\\d\\d?),(\\d\\d?)\\)->(\\S+)");

    public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
        BlockEntity te = context.getTargetBlockEntity();
        if (te instanceof BlackboardBlockTile) {
            BlackboardBlockTile tile = (BlackboardBlockTile)te;
            if (text.size() > 0 && !tile.isWaxed()) {
                BlockEntity source = context.getSourceBlockEntity();
                if (!this.parseText(text.get(0).getString(), tile)) {
                    ItemStack copyStack = CreateCompat.getDisplayedItem(context, source, i -> i.m_41720_() instanceof BlackboardItem);
                    if (!copyStack.m_41619_() && BlackboardDisplayTarget.copyBlackboard(line, context, te, tile, copyStack)) {
                        return;
                    }
                    long[] pixels = CommonConfigs.Building.BLACKBOARD_COLOR.get() != false ? BlackboardBlockTile.unpackPixelsFromString(text.get(0).getString()) : BlackboardBlockTile.unpackPixelsFromStringWhiteOnly(text.get(0).getString());
                    tile.setPixels(BlackboardBlockTile.unpackPixels(pixels));
                }
                context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
                BlackboardDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
            }
        }
    }

    private boolean parseText(String string, BlackboardBlockTile tile) {
        Matcher m = PATTERN.matcher(string);
        if (m.matches()) {
            int x = Integer.parseInt(m.group(1));
            int y = Integer.parseInt(m.group(2));
            DyeColor dye = DyeColor.m_41057_((String)m.group(3), null);
            if (x >= 0 && x <= 15 && y >= 0 && y <= 15 && dye != null) {
                if (dye != DyeColor.WHITE && dye != DyeColor.BLACK && !CommonConfigs.Building.BLACKBOARD_COLOR.get().booleanValue()) {
                    return false;
                }
                tile.setPixel(x, y, BlackboardBlock.colorToByte(dye));
                return true;
            }
        }
        return false;
    }

    private static boolean copyBlackboard(int line, DisplayLinkContext context, BlockEntity te, BlackboardBlockTile tile, ItemStack stack) {
        CompoundTag cmp = stack.m_41737_("BlockEntityTag");
        if (cmp != null && cmp.m_128441_("Pixels")) {
            tile.setPixels(BlackboardBlockTile.unpackPixels(cmp.m_128467_("Pixels")));
            context.level().m_7260_(context.getTargetPos(), te.m_58900_(), te.m_58900_(), 2);
            BlackboardDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
            return true;
        }
        return false;
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        return new DisplayTargetStats(1, 32, (DisplayTarget)this);
    }
}

