/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.foundation.advancement;

import com.cak.trading_floor.TradingFloor;
import com.cak.trading_floor.foundation.access.TFParentableAdvancement;
import com.cak.trading_floor.foundation.advancement.TFAdvancements;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.SimpleCreateTrigger;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class TFAdvancement
implements TFParentableAdvancement {
    static final String LANG = "advancement.trading_floor.";
    private final Advancement.Builder builder = Advancement.Builder.m_138353_();
    private SimpleCreateTrigger builtinTrigger;
    protected TFParentableAdvancement parent;
    Advancement datagenResult;
    protected final String id;
    protected String title;
    protected String description;

    public TFAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        Builder t = new Builder();
        b.apply(t);
        if (!t.externalTrigger) {
            this.builtinTrigger = AllTriggers.addSimple((String)(id + "_builtin"));
            this.builder.m_138386_("0", (CriterionTriggerInstance)this.builtinTrigger.instance());
        }
        this.builder.m_138362_(t.icon, (Component)Component.m_237115_((String)this.titleKey()), (Component)Component.m_237115_((String)this.descriptionKey()).m_130938_(s -> s.m_178520_(14393875)), null, t.type.frame, t.type.toast, t.type.announce, t.type.hide);
        TFAdvancements.ENTRIES.add(this);
    }

    private String titleKey() {
        return LANG + this.id;
    }

    private String descriptionKey() {
        return this.titleKey() + ".desc";
    }

    public boolean isAlreadyAwardedTo(Player player) {
        ServerPlayer sp;
        if (!(player instanceof ServerPlayer) || (sp = (ServerPlayer)player).m_20194_() == null) {
            return true;
        }
        Advancement advancement = sp.m_20194_().m_129889_().m_136041_(TradingFloor.asResource(this.id));
        if (advancement == null) {
            return true;
        }
        return sp.m_8960_().m_135996_(advancement).m_8193_();
    }

    public void awardTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (this.builtinTrigger == null) {
            throw new UnsupportedOperationException("Advancement " + this.id + " uses external Triggers, it cannot be awarded directly");
        }
        this.builtinTrigger.trigger(sp);
    }

    void save(Consumer<Advancement> t) {
        if (this.parent != null) {
            this.builder.m_138398_(this.parent.getDatagenResult());
        }
        this.datagenResult = this.builder.m_138389_(t, TradingFloor.asResource(this.id).toString());
    }

    void provideLang(BiConsumer<String, String> consumer) {
        consumer.accept(this.titleKey(), this.title);
        consumer.accept(this.descriptionKey(), this.description);
    }

    @Override
    public Advancement getDatagenResult() {
        return this.datagenResult;
    }

    public class Builder {
        private TaskType type = TaskType.NORMAL;
        private boolean externalTrigger;
        private int keyIndex;
        private ItemStack icon;

        Builder special(TaskType type) {
            this.type = type;
            return this;
        }

        Builder afterCreateRoot() {
            TFAdvancement.this.parent = (TFParentableAdvancement)AllAdvancements.ROOT;
            return this;
        }

        Builder after(TFAdvancement other) {
            TFAdvancement.this.parent = other;
            return this;
        }

        Builder icon(ItemProviderEntry<?> item) {
            return this.icon(item.asStack());
        }

        Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        Builder title(String title) {
            TFAdvancement.this.title = title;
            return this;
        }

        Builder description(String description) {
            TFAdvancement.this.description = description;
            return this;
        }

        Builder whenBlockPlaced(Block block) {
            return this.externalTrigger((CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_286031_((Block)block));
        }

        Builder whenIconCollected() {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{this.icon.m_41720_()}));
        }

        Builder whenItemCollected(ItemProviderEntry<?> item) {
            return this.whenItemCollected((ItemLike)item.asStack().m_41720_());
        }

        Builder whenItemCollected(ItemLike itemProvider) {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{itemProvider}));
        }

        Builder whenItemCollected(TagKey<Item> tag) {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(tag, null, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)}));
        }

        Builder awardedForFree() {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[0]));
        }

        Builder externalTrigger(CriterionTriggerInstance trigger) {
            TFAdvancement.this.builder.m_138386_(String.valueOf(this.keyIndex), trigger);
            this.externalTrigger = true;
            ++this.keyIndex;
            return this;
        }
    }

    public static enum TaskType {
        SILENT(FrameType.TASK, false, false, false),
        NORMAL(FrameType.TASK, true, false, false),
        NOISY(FrameType.TASK, true, true, false),
        EXPERT(FrameType.GOAL, true, true, false),
        SECRET(FrameType.GOAL, true, true, true);

        final FrameType frame;
        final boolean toast;
        final boolean announce;
        final boolean hide;

        private TaskType(FrameType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

