/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class TankUpgradeWrapper
extends UpgradeWrapperBase<TankUpgradeWrapper, TankUpgradeItem>
implements IRenderedTankUpgrade,
ITickableUpgrade,
IStackableContentsUpgrade {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int INPUT_RESULT_SLOT = 2;
    public static final int OUTPUT_RESULT_SLOT = 3;
    private static final String CONTENTS_TAG = "contents";
    private Consumer<IRenderedTankUpgrade.TankRenderInfo> updateTankRenderInfoCallback;
    private final TankInventoryHandler inventory;
    private FluidStack contents;
    private long cooldownTime = 0L;
    private static final Map<ItemStack, Function<ItemStack, IFluidHandlerItem>> CUSTOM_FLUIDHANDLER_FACTORIES = Map.of(new ItemStack((ItemLike)Items.f_42612_), stack -> new SwapEmptyFluidContainerHandler.Full((ItemStack)stack, Items.f_42590_, new ItemStack((ItemLike)Items.f_42612_), XpHelper.experienceToLiquid(8.0f), (Fluid)ModFluids.XP_STILL.get()), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_), stack -> new SwapEmptyFluidContainerHandler.Full((ItemStack)stack, Items.f_42590_, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_), 250, (Fluid)Fluids.f_76193_), new ItemStack((ItemLike)Items.f_42590_), stack -> new SwapEmptyFluidContainerHandler.Empty((ItemStack)stack, Items.f_42590_, new SwapEmptyFluidContainerHandler.FullContainerDefinition(new ItemStack((ItemLike)Items.f_42612_), XpHelper.experienceToLiquid(8.0f), (Fluid)ModFluids.XP_STILL.get()), new SwapEmptyFluidContainerHandler.FullContainerDefinition(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_), 250, (Fluid)Fluids.f_76193_)));

    protected TankUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.contents = TankUpgradeWrapper.getContents(upgrade);
        this.inventory = new TankInventoryHandler(upgrade);
        NBTHelper.getCompound(upgrade, "inventory").ifPresent(arg_0 -> ((TankInventoryHandler)this.inventory).deserializeNBT(arg_0));
        this.inventory.migrateLegacyContents();
    }

    public static FluidStack getContents(ItemStack upgrade) {
        return NBTHelper.getCompound(upgrade, CONTENTS_TAG).map(FluidStack::loadFluidStackFromNBT).orElse(FluidStack.EMPTY);
    }

    private boolean isValidFluidHandler(IFluidHandlerItem fluidHandler, boolean isOutput) {
        boolean tankEmpty = this.contents.isEmpty();
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
            if (isOutput && fluidInTank.getAmount() < fluidHandler.getTankCapacity(tank) && (fluidInTank.isEmpty() || tankEmpty || fluidInTank.isFluidEqual(this.contents))) {
                return true;
            }
            if (isOutput || fluidInTank.isEmpty() || !tankEmpty && !fluidInTank.isFluidEqual(this.contents)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNoMatchingFluid(IFluidHandlerItem fluidHandler) {
        boolean tankEmpty = this.contents.isEmpty();
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
            if (!tankEmpty && fluidInTank.isFluidEqual(this.contents)) {
                return false;
            }
            if (fluidInTank.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean matchingTankIsFull(IFluidHandlerItem fluidHandler) {
        boolean tankEmpty = this.contents.isEmpty();
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
            int tankCapacity = fluidHandler.getTankCapacity(tank);
            if (tankEmpty && fluidInTank.getAmount() < tankCapacity) {
                return false;
            }
            if (!fluidInTank.isFluidEqual(this.contents) || fluidInTank.getAmount() >= tankCapacity) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setTankRenderInfoUpdateCallback(Consumer<IRenderedTankUpgrade.TankRenderInfo> updateTankRenderInfoCallback) {
        this.updateTankRenderInfoCallback = updateTankRenderInfoCallback;
    }

    @Override
    public void forceUpdateTankRenderInfo() {
        IRenderedTankUpgrade.TankRenderInfo renderInfo = new IRenderedTankUpgrade.TankRenderInfo();
        if (!this.contents.isEmpty()) {
            renderInfo.setFluid(this.contents);
            renderInfo.setFillRatio((float)Math.round((float)this.contents.getAmount() / (float)this.getTankCapacity() * 10.0f) / 10.0f);
        }
        this.updateTankRenderInfoCallback.accept(renderInfo);
    }

    public FluidStack getContents() {
        return this.contents;
    }

    public int getTankCapacity() {
        return ((TankUpgradeItem)this.upgradeItem).getTankCapacity(this.storageWrapper);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    private int getMaxInOut() {
        return (int)Math.max(1000.0, (double)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows()) * ((TankUpgradeItem)this.upgradeItem).getAdjustedStackMultiplier(this.storageWrapper));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        int capacity = this.getTankCapacity();
        if (this.contents.getAmount() >= capacity || !this.contents.isEmpty() && !resource.isFluidEqual(this.contents)) {
            return 0;
        }
        int toFill = Math.min(capacity - this.contents.getAmount(), resource.getAmount());
        if (!ignoreInOutLimit) {
            toFill = Math.min(this.getMaxInOut(), toFill);
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (this.contents.isEmpty()) {
                this.contents = new FluidStack(resource, toFill);
            } else {
                this.contents.setAmount(this.contents.getAmount() + toFill);
            }
            this.serializeContents();
        }
        return toFill;
    }

    private void serializeContents() {
        this.upgrade.m_41700_(CONTENTS_TAG, (Tag)this.contents.writeToNBT(new CompoundTag()));
        this.save();
        this.forceUpdateTankRenderInfo();
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        if (this.contents.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int toDrain = Math.min(maxDrain, this.contents.getAmount());
        if (!ignoreInOutLimit) {
            toDrain = Math.min(this.getMaxInOut(), toDrain);
        }
        FluidStack ret = new FluidStack(this.contents, toDrain);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (toDrain == this.contents.getAmount()) {
                this.contents = FluidStack.EMPTY;
            } else {
                this.contents.setAmount(this.contents.getAmount() - toDrain);
            }
            this.serializeContents();
        }
        return ret;
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (level.m_46467_() < this.cooldownTime) {
            return;
        }
        boolean didSomething = this.tryDraining(this.inventory.getStackInSlot(0));
        if (didSomething |= this.tryFilling(this.inventory.getStackInSlot(1))) {
            this.cooldownTime = level.m_46467_() + (long)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().autoFillDrainContainerCooldown.get()).intValue();
        }
    }

    private boolean tryDraining(ItemStack inputSlotStack) {
        ItemStack stackToDrain = inputSlotStack;
        if (inputSlotStack.m_41613_() > 1) {
            stackToDrain = inputSlotStack.m_255036_(1);
            if (!this.drainStack(stackToDrain, true, stack -> {})) {
                return false;
            }
            return this.drainStack(stackToDrain, false, stack -> this.inventory.setStackInSlot(0, inputSlotStack.m_255036_(inputSlotStack.m_41613_() - 1)));
        }
        return this.drainStack(stackToDrain, false, stack -> this.inventory.setStackInSlot(0, (ItemStack)stack));
    }

    private boolean drainStack(ItemStack stackToDrain, boolean simulateFullDrain, Consumer<ItemStack> updateContainerStack) {
        return this.getFluidHandler(stackToDrain).map(fluidHandler -> this.drainHandler((IFluidHandlerItem)fluidHandler, updateContainerStack, true, simulateFullDrain)).orElse(false);
    }

    private Optional<IFluidHandlerItem> getFluidHandler(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().or(() -> TankUpgradeWrapper.getCustomFluidHandler(stack));
    }

    private boolean tryFilling(ItemStack outputSlotStack) {
        ItemStack stackToFill = outputSlotStack;
        if (outputSlotStack.m_41613_() > 1) {
            stackToFill = outputSlotStack.m_255036_(1);
            if (!this.fillStack(stackToFill, true, stack -> {})) {
                return false;
            }
            return this.fillStack(stackToFill, false, stack -> this.inventory.setStackInSlot(1, outputSlotStack.m_255036_(outputSlotStack.m_41613_() - 1)));
        }
        return this.fillStack(stackToFill, false, stack -> this.inventory.setStackInSlot(1, (ItemStack)stack));
    }

    private boolean fillStack(ItemStack outputSlotStack, boolean simulateFullFill, Consumer<ItemStack> updateContainerStack) {
        return this.getFluidHandler(outputSlotStack).map(fluidHandler -> this.fillHandler((IFluidHandlerItem)fluidHandler, updateContainerStack, true, simulateFullFill)).orElse(false);
    }

    public void interactWithCursorStack(ItemStack cursorStack, Consumer<ItemStack> updateContainerStack) {
        this.getFluidHandler(cursorStack).ifPresent(fluidHandler -> {
            FluidStack tankContents = this.getContents();
            if (tankContents.isEmpty()) {
                this.drainHandler((IFluidHandlerItem)fluidHandler, updateContainerStack);
            } else if (!this.fillHandler((IFluidHandlerItem)fluidHandler, updateContainerStack, false, false)) {
                this.drainHandler((IFluidHandlerItem)fluidHandler, updateContainerStack);
            }
        });
    }

    private static Optional<IFluidHandlerItem> getCustomFluidHandler(ItemStack stack) {
        return CUSTOM_FLUIDHANDLER_FACTORIES.entrySet().stream().filter(e -> ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((ItemStack)e.getKey()))).map(e -> (IFluidHandlerItem)((Function)e.getValue()).apply(stack)).findFirst();
    }

    public boolean fillHandler(IFluidHandlerItem fluidHandler, Consumer<ItemStack> updateContainerStack, boolean moveFullToResult, boolean simulateIncludingFullFill) {
        if (!this.contents.isEmpty() && this.isValidFluidHandler(fluidHandler, true)) {
            ItemStack containerCopy;
            int filled = fluidHandler.fill(new FluidStack(this.contents, Math.min(1000, this.contents.getAmount())), IFluidHandler.FluidAction.SIMULATE);
            if (filled <= 0) {
                return false;
            }
            if (moveFullToResult && this.isFullAfterFillButUnableToInsertIntoResult(containerCopy = fluidHandler.getContainer().m_41777_())) {
                return false;
            }
            if (simulateIncludingFullFill) {
                return fluidHandler.getTanks() > 0 && this.drain(filled, IFluidHandler.FluidAction.SIMULATE, false).getAmount() == fluidHandler.getTankCapacity(0);
            }
            FluidStack drained = this.drain(filled, IFluidHandler.FluidAction.EXECUTE, false);
            fluidHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            if (moveFullToResult && this.getFluidHandler(fluidHandler.getContainer()).map(this::matchingTankIsFull).orElse(false).booleanValue()) {
                updateContainerStack.accept(ItemStack.f_41583_);
                this.inventory.insertItem(3, fluidHandler.getContainer(), false);
            } else {
                updateContainerStack.accept(fluidHandler.getContainer());
            }
            return true;
        }
        return false;
    }

    private boolean isFullAfterFillButUnableToInsertIntoResult(ItemStack containerCopy) {
        return this.getFluidHandler(containerCopy).map(copyFluidHandler -> {
            copyFluidHandler.fill(new FluidStack(this.contents, Math.min(1000, this.contents.getAmount())), IFluidHandler.FluidAction.EXECUTE);
            return this.getFluidHandler(copyFluidHandler.getContainer()).map(fh -> {
                int tank = this.getMatchingTank((IFluidHandlerItem)fh, this.contents);
                if (tank < 0) {
                    return true;
                }
                return fh.getFluidInTank(tank).getAmount() == fh.getTankCapacity(tank) && !this.inventory.insertItem(3, copyFluidHandler.getContainer(), true).m_41619_();
            }).orElse(true);
        }).orElse(true);
    }

    public void drainHandler(IFluidHandlerItem fluidHandler, Consumer<ItemStack> updateContainerStack) {
        this.drainHandler(fluidHandler, updateContainerStack, false, false);
    }

    public boolean drainHandler(IFluidHandlerItem fluidHandler, Consumer<ItemStack> updateContainerStack, boolean moveEmptyToResult, boolean simulateIncludingFullDrain) {
        if (this.isValidFluidHandler(fluidHandler, false)) {
            ItemStack containerCopy;
            FluidStack extracted;
            FluidStack fluidStack = extracted = this.contents.isEmpty() ? fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE) : fluidHandler.drain(new FluidStack(this.contents, Math.min(1000, this.getTankCapacity() - this.contents.getAmount())), IFluidHandler.FluidAction.SIMULATE);
            if (extracted.isEmpty()) {
                return false;
            }
            if (moveEmptyToResult && this.isEmptyAfterDrainButUnableToInsertIntoResult(containerCopy = fluidHandler.getContainer().m_41777_(), extracted)) {
                return false;
            }
            if (simulateIncludingFullDrain) {
                return fluidHandler.getTanks() > 0 && this.fill(extracted, IFluidHandler.FluidAction.SIMULATE, false) == fluidHandler.getTankCapacity(0);
            }
            int filled = this.fill(extracted, IFluidHandler.FluidAction.EXECUTE, false);
            FluidStack toExtract = filled == extracted.getAmount() ? extracted : new FluidStack(extracted, filled);
            fluidHandler.drain(toExtract, IFluidHandler.FluidAction.EXECUTE);
            if (moveEmptyToResult && this.getFluidHandler(fluidHandler.getContainer()).map(this::hasNoMatchingFluid).orElse(true).booleanValue()) {
                updateContainerStack.accept(ItemStack.f_41583_);
                this.inventory.insertItem(2, fluidHandler.getContainer(), false);
            } else {
                updateContainerStack.accept(fluidHandler.getContainer());
            }
            return true;
        }
        return false;
    }

    private boolean isEmptyAfterDrainButUnableToInsertIntoResult(ItemStack containerCopy, FluidStack extracted) {
        return this.getFluidHandler(containerCopy).map(copyFluidHandler -> {
            int tank = this.getMatchingTank((IFluidHandlerItem)copyFluidHandler, extracted);
            if (tank < 0) {
                return true;
            }
            copyFluidHandler.drain(extracted, IFluidHandler.FluidAction.EXECUTE);
            return this.getFluidHandler(copyFluidHandler.getContainer()).map(fh -> fh.getTanks() <= tank || fh.getFluidInTank(tank).isEmpty()).orElse(true) != false && !this.inventory.insertItem(2, copyFluidHandler.getContainer(), true).m_41619_();
        }).orElse(true);
    }

    private int getMatchingTank(IFluidHandlerItem fluidHandler, FluidStack matchTo) {
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
            if (!fluidInTank.equals((Object)matchTo)) continue;
            return tank;
        }
        return -1;
    }

    @Override
    public int getMinimumMultiplierRequired() {
        return (int)Math.ceil((float)this.contents.getAmount() / (float)((TankUpgradeItem)this.upgradeItem).getBaseCapacity(this.storageWrapper));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    private class TankInventoryHandler
    extends ItemStackHandler {
        private final ItemStack upgrade;

        public TankInventoryHandler(ItemStack upgrade) {
            super(4);
            this.upgrade = upgrade;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.upgrade.m_41700_("inventory", (Tag)this.serializeNBT());
            TankUpgradeWrapper.this.save();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.m_41619_() || this.hasValidFluidHandler(stack, false);
            }
            if (slot == 1) {
                return stack.m_41619_() || this.hasValidFluidHandler(stack, true);
            }
            return slot == 2 || slot == 3;
        }

        private boolean hasValidFluidHandler(ItemStack stack, boolean isOutput) {
            return TankUpgradeWrapper.this.getFluidHandler(stack).map(fluidHandler -> TankUpgradeWrapper.this.isValidFluidHandler((IFluidHandlerItem)fluidHandler, isOutput)).orElse(false);
        }

        private void migrateLegacyContents() {
            ItemStack outputStack;
            ItemStack inputStack = this.getStackInSlot(0);
            if (!inputStack.m_41619_() && !this.hasValidFluidHandler(inputStack, false)) {
                this.setStackInSlot(0, ItemStack.f_41583_);
                this.setStackInSlot(2, inputStack);
            }
            if (!(outputStack = this.getStackInSlot(1)).m_41619_() && !this.hasValidFluidHandler(outputStack, true)) {
                this.setStackInSlot(1, ItemStack.f_41583_);
                this.setStackInSlot(3, outputStack);
            }
        }

        public void setSize(int size) {
            super.setSize(4);
        }
    }

    private static abstract class SwapEmptyFluidContainerHandler
    implements IFluidHandlerItem {
        private ItemStack container;
        private final Item empty;
        private final Map<FluidStack, FullContainerDefinition> fullContainers = new HashMap<FluidStack, FullContainerDefinition>();
        private FluidStack contents;

        protected SwapEmptyFluidContainerHandler(ItemStack container, Item empty, FluidStack contents, FullContainerDefinition ... fullContainers) {
            this.container = container;
            this.empty = empty;
            Arrays.stream(fullContainers).forEach(fc -> this.fullContainers.put(fc.validFluid, (FullContainerDefinition)fc));
            this.contents = contents;
        }

        public ItemStack getContainer() {
            return this.container;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.contents;
        }

        public int getTankCapacity(int tank) {
            return this.getMatchingDefinition().map(FullContainerDefinition::capacity).orElseGet(() -> this.fullContainers.values().stream().mapToInt(FullContainerDefinition::capacity).max().orElse(0));
        }

        private Optional<FullContainerDefinition> getMatchingDefinition() {
            return this.fullContainers.entrySet().stream().filter(e -> ((FluidStack)e.getKey()).isFluidEqual(this.contents)).map(Map.Entry::getValue).findFirst();
        }

        public boolean isFluidValid(int i, FluidStack fluidStack) {
            return !this.contents.isEmpty() ? this.contents.isFluidEqual(fluidStack) : this.fullContainers.keySet().stream().anyMatch(validFluid -> validFluid.isFluidEqual(fluidStack));
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            if (!this.isFluidValid(0, fluidStack) || this.container.m_41720_() != this.empty) {
                return 0;
            }
            return this.findFirstFullContainer(fluidStack).map(fullContainer -> {
                int result = 0;
                int capacity = fullContainer.capacity();
                if (fluidStack.getAmount() >= capacity) {
                    result = capacity;
                    if (fluidAction == IFluidHandler.FluidAction.EXECUTE) {
                        this.container = fullContainer.full().m_41777_();
                        this.contents = new FluidStack(fluidStack, capacity);
                    }
                }
                return result;
            }).orElse(0);
        }

        private Optional<FullContainerDefinition> findFirstFullContainer(FluidStack fluidStack) {
            return this.fullContainers.entrySet().stream().filter(e -> ((FluidStack)e.getKey()).isFluidEqual(fluidStack)).findFirst().map(Map.Entry::getValue);
        }

        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return this.findFirstFullContainer(this.contents).map(fullContainer -> {
                if (fluidStack.isEmpty() || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.container, (ItemStack)fullContainer.full())) {
                    return FluidStack.EMPTY;
                }
                FluidStack result = FluidStack.EMPTY;
                if (this.isFluidValid(0, fluidStack) && fluidStack.getAmount() >= fullContainer.capacity()) {
                    result = new FluidStack(fluidStack, fullContainer.capacity());
                    if (fluidAction == IFluidHandler.FluidAction.EXECUTE) {
                        this.container = new ItemStack((ItemLike)this.empty);
                        this.contents = FluidStack.EMPTY;
                    }
                }
                return result;
            }).orElse(FluidStack.EMPTY);
        }

        public FluidStack drain(int toDrain, IFluidHandler.FluidAction fluidAction) {
            if (this.container.m_41720_() == this.empty || toDrain < this.contents.getAmount()) {
                return FluidStack.EMPTY;
            }
            return this.drain(this.contents, fluidAction);
        }

        private record FullContainerDefinition(ItemStack full, int capacity, FluidStack validFluid) {
            public FullContainerDefinition(ItemStack full, int capacity, Fluid validFluid) {
                this(full, capacity, new FluidStack(validFluid, capacity));
            }
        }

        public static class Full
        extends SwapEmptyFluidContainerHandler {
            public Full(ItemStack container, Item empty, ItemStack full, int capacity, Fluid validFluid) {
                super(container, empty, new FluidStack(validFluid, capacity), new FullContainerDefinition(full, capacity, new FluidStack(validFluid, capacity)));
            }
        }

        public static class Empty
        extends SwapEmptyFluidContainerHandler {
            public Empty(ItemStack container, Item empty, FullContainerDefinition ... fullContainers) {
                super(container, empty, FluidStack.EMPTY, fullContainers);
            }
        }
    }
}

