/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.recipe;

import com.google.gson.JsonObject;
import galena.nirvana.index.NirvanaItems;
import galena.nirvana.index.NirvanaRecipeTypes;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import org.jetbrains.annotations.Nullable;

public class SuspicousCraftingRecipe
extends CustomRecipe {
    private final Item result;
    private final Item base;
    private final int requiredFlowers;
    private final int requiredWeed;
    private final int durationFactor;

    public SuspicousCraftingRecipe(ResourceLocation id, CraftingBookCategory category, Item result, Item base, int requiredFlowers, int requiredWeed, int durationFactor) {
        super(id, category);
        this.result = result;
        this.base = base;
        this.requiredFlowers = requiredFlowers;
        this.requiredWeed = requiredWeed;
        this.durationFactor = durationFactor;
    }

    public boolean matches(CraftingContainer container, Level level) {
        @Nullable Item flowerType = null;
        int flowerCount = 0;
        int weedCount = 0;
        boolean hasBase = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (NirvanaItems.WEED.isIn(stack)) {
                ++weedCount;
                continue;
            }
            if (stack.m_204117_(ItemTags.f_13145_)) {
                if (flowerType == null) {
                    flowerType = stack.m_41720_();
                }
                if (stack.m_150930_(flowerType)) {
                    ++flowerCount;
                    continue;
                }
                return false;
            }
            if (stack.m_150930_(this.base) && !hasBase) {
                hasBase = true;
                continue;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return hasBase && weedCount == this.requiredWeed && flowerCount == this.requiredFlowers;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack result = new ItemStack((ItemLike)this.result);
        for (int i = 0; i < container.m_6643_(); ++i) {
            SuspiciousEffectHolder suspiciousEffectHolder;
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || (suspiciousEffectHolder = SuspiciousEffectHolder.m_257980_((ItemLike)stack.m_41720_())) == null) continue;
            SuspiciousStewItem.m_43258_((ItemStack)result, (MobEffect)suspiciousEffectHolder.m_53521_(), (int)(suspiciousEffectHolder.m_53522_() * this.durationFactor));
            break;
        }
        return result;
    }

    public boolean m_8004_(int i, int j) {
        return i >= 3 && j >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)NirvanaRecipeTypes.SUSPICIOUS_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<SuspicousCraftingRecipe> {
        public SuspicousCraftingRecipe fromJson(ResourceLocation id, JsonObject json) {
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Item item = GsonHelper.m_13909_((JsonObject)json, (String)"result");
            Item base = GsonHelper.m_13909_((JsonObject)json, (String)"base");
            int requiredFlowers = GsonHelper.m_13824_((JsonObject)json, (String)"flowers", (int)1);
            int requiredWeed = GsonHelper.m_13824_((JsonObject)json, (String)"weed", (int)1);
            int durationFactor = GsonHelper.m_13824_((JsonObject)json, (String)"durationFactor", (int)1);
            return new SuspicousCraftingRecipe(id, category, item, base, requiredFlowers, requiredWeed, durationFactor);
        }

        public SuspicousCraftingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            Item item = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
            Item base = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
            int requiredFlowers = buffer.readInt();
            int requiredWeed = buffer.readInt();
            int durationFactor = buffer.readInt();
            return new SuspicousCraftingRecipe(id, category, item, base, requiredFlowers, requiredWeed, durationFactor);
        }

        public void toNetwork(FriendlyByteBuf buffer, SuspicousCraftingRecipe recipe) {
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)recipe.result);
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)recipe.base);
            buffer.writeInt(recipe.requiredFlowers);
            buffer.writeInt(recipe.requiredWeed);
            buffer.writeInt(recipe.durationFactor);
        }
    }
}

