/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.forge.mixins;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import galena.nirvana.index.NirvanaItems;
import java.util.Collection;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GenericItemFilling.class}, remap=false)
public class GenericItemFillingMixin {
    @Unique
    private static boolean nirvana$isValidPotion(FluidStack fluid) {
        return fluid.getFluid().m_6212_((Fluid)AllFluids.POTION.get()) && NBTHelper.readEnum((CompoundTag)fluid.getOrCreateTag(), (String)"Bottle", PotionFluid.BottleType.class) == PotionFluid.BottleType.REGULAR;
    }

    @Inject(require=0, cancellable=true, at={@At(value="HEAD")}, method={"canItemBeFilled(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Z"})
    private static void canBongBeFilled(Level world, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (NirvanaItems.BONG.isIn(stack)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(require=0, cancellable=true, at={@At(value="HEAD")}, method={"getRequiredAmountForItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraftforge/fluids/FluidStack;)I"})
    private static void getRequiredAmountForBong(Level world, ItemStack stack, FluidStack availableFluid, CallbackInfoReturnable<Integer> cir) {
        if (NirvanaItems.BONG.isIn(stack) && GenericItemFillingMixin.nirvana$isValidPotion(availableFluid)) {
            cir.setReturnValue((Object)PotionFluidHandler.getRequiredAmountForFilledBottle((ItemStack)stack, (FluidStack)availableFluid));
        }
    }

    @Inject(require=0, cancellable=true, at={@At(value="HEAD")}, method={"fillItem(Lnet/minecraft/world/level/Level;ILnet/minecraft/world/item/ItemStack;Lnet/minecraftforge/fluids/FluidStack;)Lnet/minecraft/world/item/ItemStack;"})
    private static void fillBong(Level world, int requiredAmount, ItemStack stack, FluidStack availableFluid, CallbackInfoReturnable<ItemStack> cir) {
        if (NirvanaItems.BONG.isIn(stack) && GenericItemFillingMixin.nirvana$isValidPotion(availableFluid)) {
            CompoundTag tag = availableFluid.getOrCreateTag();
            ItemStack bongStack = NirvanaItems.POTION_BONG.asStack();
            PotionUtils.m_43549_((ItemStack)bongStack, (Potion)PotionUtils.m_43577_((CompoundTag)tag));
            PotionUtils.m_43552_((ItemStack)bongStack, (Collection)PotionUtils.m_43573_((CompoundTag)tag));
            stack.m_41774_(1);
            cir.setReturnValue((Object)bongStack);
        }
    }
}

