/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.core.misc.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gumillea.cosmopolitan.common.blockEntity.FrozenDessertTubBlockEntity;
import com.gumillea.cosmopolitan.core.reg.CosmoRecipes;
import com.gumillea.cosmopolitan.core.util.CosmoItemTags;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class TubExtractRecipe
implements Recipe<Container> {
    private final ResourceLocation location;
    private final Ingredient ingredient;
    private final ItemStack resultItem;
    private final FluidStack fluid;

    public TubExtractRecipe(ResourceLocation location, Ingredient ingredient, ItemStack result, FluidStack fluid) {
        this.location = location;
        this.ingredient = ingredient;
        this.resultItem = result;
        this.fluid = fluid;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public boolean m_5818_(Container inv, Level world) {
        return false;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.resultItem;
    }

    public ResourceLocation m_6423_() {
        return this.location;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CosmoRecipes.TUB_EXTRACT_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CosmoRecipes.TUB_EXTRACT_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.ingredient);
        return list;
    }

    @Nullable
    public static ItemStack tryApply(Level level, FrozenDessertTubBlockEntity tub, ItemStack heldItem, Player player, InteractionHand hand) {
        List recipes = level.m_7465_().m_44013_((RecipeType)CosmoRecipes.TUB_EXTRACT_TYPE.get());
        for (TubExtractRecipe recipe : recipes) {
            if (!recipe.getIngredient().test(heldItem)) continue;
            FluidStack ingredient = recipe.getFluid();
            FluidStack inTank = tub.getTank().getFluid();
            if (!inTank.getFluid().m_6212_(ingredient.getFluid()) || inTank.getAmount() < ingredient.getAmount()) continue;
            tub.getFluidHandler().drain(ingredient.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            ItemStack result = recipe.m_8043_(level.m_9598_()).m_41777_();
            if (inTank.hasTag() && inTank.getTag().m_128471_("has_cream") && result.m_41614_() && !result.m_204117_(CosmoItemTags.CREAM)) {
                result.m_41784_().m_128379_("has_cream", true);
            }
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, result);
                } else if (!player.m_36356_(result)) {
                    player.m_36176_(result, false);
                }
                return player.m_21120_(hand);
            }
            if (!player.m_36356_(result)) {
                player.m_36176_(result, false);
            }
            return heldItem;
        }
        return ItemStack.f_41583_;
    }

    public static class Serializer
    implements RecipeSerializer<TubExtractRecipe> {
        public TubExtractRecipe fromJson(ResourceLocation location, JsonObject json) {
            JsonElement ingElem = json.get("ingredient");
            Ingredient ingredient = Ingredient.f_43901_;
            FluidStack fluidStack = FluidStack.EMPTY;
            if (ingElem.isJsonArray()) {
                for (JsonElement el : ingElem.getAsJsonArray()) {
                    JsonObject obj = el.getAsJsonObject();
                    if (obj.has("fluid")) {
                        JsonObject f = obj.getAsJsonObject("fluid");
                        ResourceLocation id = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)f, (String)"name"));
                        int amt = GsonHelper.m_13824_((JsonObject)f, (String)"amount", (int)0);
                        fluidStack = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(id)), amt);
                        continue;
                    }
                    ingredient = Ingredient.m_43917_((JsonElement)obj);
                }
            } else {
                JsonObject obj = ingElem.getAsJsonObject();
                if (obj.has("fluid")) {
                    JsonObject f = obj.getAsJsonObject("fluid");
                    ResourceLocation id = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)f, (String)"name"));
                    int amt = GsonHelper.m_13824_((JsonObject)f, (String)"amount", (int)0);
                    fluidStack = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(id)), amt);
                } else {
                    ingredient = Ingredient.m_43917_((JsonElement)obj);
                }
            }
            JsonObject resultObj = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack result = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)resultObj, (String)"item")))), GsonHelper.m_13824_((JsonObject)resultObj, (String)"count", (int)1));
            return new TubExtractRecipe(location, ingredient, result, fluidStack);
        }

        @Nullable
        public TubExtractRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf byteBuf) {
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)byteBuf);
            ItemStack result = byteBuf.m_130267_();
            FluidStack stack = FluidStack.readFromPacket((FriendlyByteBuf)byteBuf);
            return new TubExtractRecipe(location, ingredient1, result, stack);
        }

        public void toNetwork(FriendlyByteBuf byteBuf, TubExtractRecipe recipe) {
            recipe.ingredient.m_43923_(byteBuf);
            byteBuf.m_130055_(recipe.resultItem);
            recipe.fluid.writeToPacket(byteBuf);
        }
    }
}

