/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.common.item;

import com.gumillea.cosmopolitan.CosmoConfig;
import com.gumillea.cosmopolitan.common.item.EffectItem;
import com.gumillea.cosmopolitan.core.reg.CosmoItems;
import com.gumillea.cosmopolitan.core.util.CosmoCompat;
import com.teamabnormals.neapolitan.common.item.HealingItem;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBiomes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.registries.RegistryObject;
import org.violetmoon.quark.content.world.module.GlimmeringWealdModule;

public class GulimeItem
extends EffectItem {
    private final boolean large;
    private final RegistryObject<Item> result;

    public GulimeItem(Item.Properties properties, boolean large, RegistryObject<Item> result) {
        super(properties.m_41487_(large ? 16 : 64));
        this.large = large;
        this.result = result;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        ItemStack resultStack = super.m_5922_(stack, level, living);
        if (CosmoCompat.nea && (this == CosmoItems.STRAWBERRY_GULIME.get() || this == CosmoItems.STRAWBERRY_GULIME_SMALL.get())) {
            HealingItem.applyHealing((float)2.0f, (LevelAccessor)level, (LivingEntity)living);
        }
        if (!level.f_46443_ && this.large && living instanceof Player) {
            Player player = (Player)living;
            ItemStack smallGulime = new ItemStack((ItemLike)this.result.get(), 4);
            if (!player.m_150109_().m_36054_(smallGulime)) {
                player.m_36176_(smallGulime, false);
            }
        }
        return resultStack;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.f_46443_ || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.large) {
            return;
        }
        long time = level.m_46467_();
        if (time % (long)((Integer)CosmoConfig.Common.GULIME_TICK.get()).intValue() != 0L) {
            return;
        }
        if ((double)level.m_213780_().m_188501_() < (Double)CosmoConfig.Common.GULIME_CHANCE.get()) {
            return;
        }
        int gulimes = 0;
        for (ItemStack invStack : player.m_150109_().f_35974_) {
            if (!invStack.m_150930_((Item)this)) continue;
            gulimes += invStack.m_41613_();
        }
        if (gulimes >= 4) {
            Item actualGumlime = (Item)this.result.get();
            int removed = 0;
            for (int i = 0; i < player.m_150109_().f_35974_.size() && removed < 4; ++i) {
                ItemStack invStack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!invStack.m_150930_((Item)this)) continue;
                int toRemove = Math.min(4 - removed, invStack.m_41613_());
                invStack.m_41774_(toRemove);
                removed += toRemove;
            }
            HashMap<ResourceKey, Item> BIOME_GULIME_MAP = new HashMap<ResourceKey, Item>(Map.of(Biomes.f_151785_, (Item)CosmoItems.UNDERGROUND_GULIME.get(), Biomes.f_186763_, (Item)CosmoItems.TAIGA_GULIME.get(), Biomes.f_48164_, (Item)CosmoItems.CHORUS_GULIME.get()));
            if (CosmoCompat.qua) {
                BIOME_GULIME_MAP.put(GlimmeringWealdModule.BIOME_KEY, (Item)CosmoItems.GLIMMERING_GULIME.get());
            }
            if (CosmoCompat.nea) {
                BIOME_GULIME_MAP.put(NeapolitanBiomes.STRAWBERRY_FIELDS, (Item)CosmoItems.STRAWBERRY_GULIME.get());
            }
            if (this == CosmoItems.GULIME_SMALL.get()) {
                Holder biome = level.m_204166_(player.m_20183_());
                actualGumlime = BIOME_GULIME_MAP.getOrDefault(biome.m_203543_().orElse(null), (Item)this.result.get());
            }
            ItemStack resultGulime = new ItemStack((ItemLike)actualGumlime);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12392_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_150109_().m_36054_(resultGulime);
        }
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_11966_;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11966_;
    }
}

