/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.util.formulae;

import com.flansmod.common.FlansMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class FloatFormula<TInputEnum extends Enum<TInputEnum>> {
    protected final List<Term> Terms = new ArrayList<Term>();

    public void AddTerms(@Nonnull Collection<Term> terms) {
        for (Term term : terms) {
            this.Terms.add(new Term(term.Coefficient, term.Flags));
        }
    }

    @Nonnull
    public FloatFormula<TInputEnum> BakeInput(int inputTypeIndex, float value) {
        int inputFlag = 1 << inputTypeIndex;
        for (Term term : this.Terms) {
            if ((term.Flags & inputTypeIndex) == 0) continue;
            term.Coefficient *= value;
            term.Flags ^= inputTypeIndex;
        }
        return this;
    }

    @Nonnull
    public FloatFormula<TInputEnum> BakeInput(@Nonnull TInputEnum inputType, float value) {
        return this.BakeInput((TInputEnum)((Enum)inputType).ordinal(), value);
    }

    public float Evaluate(@Nonnull Function<Integer, Float> resolver) {
        float value = 0.0f;
        for (Term term : this.Terms) {
            float termValue = term.Coefficient;
            int i = 0;
            for (int remainingFlags = term.Flags; remainingFlags != 0; remainingFlags >>= 1) {
                boolean hasFlagI;
                boolean bl = hasFlagI = (remainingFlags & 1) != 0;
                if (hasFlagI) {
                    termValue *= resolver.apply(i).floatValue();
                }
                ++i;
            }
            value += termValue;
        }
        return value;
    }

    public float Evaluate() {
        float value = 0.0f;
        for (Term term : this.Terms) {
            if (term.Flags != 0) {
                FlansMod.LOGGER.error("Called Evaluate on a FloatFormula with coeffecients outstanding and no resolver, these will be assumed to be 0.");
            }
            value += term.Coefficient;
        }
        return value;
    }

    @SafeVarargs
    public final FloatFormula<TInputEnum> AddTerm(float coeff, TInputEnum ... inputs) {
        int flags = 0;
        for (TInputEnum input : inputs) {
            flags |= 1 << ((Enum)input).ordinal();
            if (((Enum)input).ordinal() <= 32) continue;
            FlansMod.LOGGER.error("Trying to add a " + input + " term to a formula, over 32 max.");
        }
        for (Term term : this.Terms) {
            if (term.Flags != flags) continue;
            term.Coefficient += coeff;
            return this;
        }
        this.Terms.add(new Term(coeff, flags));
        return this;
    }

    public float Calculate(float ... inputs) {
        float sum = 0.0f;
        for (Term term : this.Terms) {
            float add = term.Coefficient;
            for (int i = 0; i < inputs.length; ++i) {
                if ((term.Flags << i & 1) == 0) continue;
                add *= inputs[i];
            }
            sum += add;
        }
        return sum;
    }

    @SafeVarargs
    public final float Calculate(Supplier<Float> ... inputs) {
        float sum = 0.0f;
        for (Term term : this.Terms) {
            float add = term.Coefficient;
            for (int i = 0; i < inputs.length; ++i) {
                if ((term.Flags << i & 1) == 0) continue;
                add *= inputs[i].get().floatValue();
            }
            sum += add;
        }
        return sum;
    }

    protected static class Term {
        public float Coefficient;
        public int Flags;

        public Term(float coeff, int flags) {
            this.Coefficient = coeff;
            this.Flags = flags;
        }
    }
}

