/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.plugins.jei;

import com.flansmod.common.crafting.ingredients.TieredPartIngredient;
import com.flansmod.common.crafting.recipes.GunFabricationRecipe;
import com.flansmod.common.types.crafting.EMaterialType;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.plugins.jei.FlansDrawable;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;

public class GunFabricationDrawable {

    public static class Icon
    extends FlansDrawable {
        private static final int WIDTH = 16;
        private static final int HEIGHT = 16;

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }

        public void draw(@Nonnull GuiGraphics graphics, int xOffset, int yOffset) {
            graphics.m_280163_(TEXTURE, xOffset, yOffset, 16.0f, 200.0f, 16, 16, 256, 256);
        }
    }

    public static class Background
    extends FlansDrawable {
        private static final int WIDTH = 160;
        private static final int HEIGHT = 48;

        public int getWidth() {
            return 160;
        }

        public int getHeight() {
            return 48;
        }

        public void draw(@Nonnull GuiGraphics graphics, int xOffset, int yOffset) {
            graphics.m_280163_(TEXTURE, xOffset, yOffset, 1.0f, 27.0f, 160, 48, 256, 256);
        }

        public void DrawExtras(@Nonnull GunFabricationRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics graphics, double mouseX, double mouseY) {
            int numInputs = recipe.InputIngredients.size();
            for (int i = 0; i < numInputs; ++i) {
                Ingredient input = (Ingredient)recipe.InputIngredients.get(i);
                if (input instanceof TieredPartIngredient) {
                    TieredPartIngredient tiered = (TieredPartIngredient)input;
                    graphics.m_280163_(TEXTURE, 8 + 22 * i, 1, (float)(1 + tiered.MaterialTierMin * 22), 95.0f, 22, 47, 256, 256);
                    if (Background.InBox(mouseX, mouseY, 8 + 22 * i, 22, 1, 6)) {
                        graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"crafting.match_tiers_above", (Object[])new Object[]{tiered.MaterialTierMin}), Maths.floor(mouseX), Maths.floor(mouseY));
                    }
                    this.DrawMaterialTypeBox(tiered, EMaterialType.Wood, graphics, 8 + 22 * i + 3, 27, 3, 145, mouseX, mouseY);
                    this.DrawMaterialTypeBox(tiered, EMaterialType.Glass, graphics, 8 + 22 * i + 9, 27, 9, 145, mouseX, mouseY);
                    this.DrawMaterialTypeBox(tiered, EMaterialType.Metal, graphics, 8 + 22 * i + 15, 27, 15, 145, mouseX, mouseY);
                    this.DrawMaterialTypeBox(tiered, EMaterialType.Composite, graphics, 8 + 22 * i + 3, 32, 3, 150, mouseX, mouseY);
                    this.DrawMaterialTypeBox(tiered, EMaterialType.Electronic, graphics, 8 + 22 * i + 9, 32, 9, 150, mouseX, mouseY);
                    this.DrawMaterialTypeBox(tiered, EMaterialType.Fabric, graphics, 8 + 22 * i + 15, 32, 15, 150, mouseX, mouseY);
                    continue;
                }
                graphics.m_280163_(TEXTURE, 8 + 22 * i, 1, 1.0f, 95.0f, 22, 47, 256, 256);
            }
        }

        private void DrawMaterialTypeBox(@Nonnull TieredPartIngredient tiered, @Nonnull EMaterialType materialType, @Nonnull GuiGraphics graphics, int x, int y, int iconX, int iconY, double mouseX, double mouseY) {
            if (tiered.IsMatchingMaterialType(materialType)) {
                graphics.m_280163_(TEXTURE, x, y, (float)iconX, (float)iconY, 5, 4, 256, 256);
                if (Background.InBox(mouseX, mouseY, x, 5, y, 4)) {
                    graphics.m_280557_(Minecraft.m_91087_().f_91062_, materialType.ToComponent(), Maths.floor(mouseX), Maths.floor(mouseY));
                }
            }
        }
    }
}

