/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.plugins.jei;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.recipes.GunFabricationRecipe;
import com.flansmod.common.crafting.recipes.PartFabricationRecipe;
import com.flansmod.common.types.crafting.WorkbenchDefinition;
import com.flansmod.plugins.jei.GunCraftingCategory;
import com.flansmod.plugins.jei.PartCraftingCategory;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class FlansModJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("flansmod", "jei_plugin");
    private static final RecipeType<PartFabricationRecipe> PART_FABRICATION_RECIPE_TYPE = RecipeType.create((String)"flansmod", (String)"part_fabrication", PartFabricationRecipe.class);
    private static final PartCraftingCategory PART_CRAFTING_CATEGORY = new PartCraftingCategory(PART_FABRICATION_RECIPE_TYPE);
    private static final RecipeType<GunFabricationRecipe> GUN_FABRICATION_RECIPE_TYPE = RecipeType.create((String)"flansmod", (String)"gun_fabrication", GunFabricationRecipe.class);
    private static final GunCraftingCategory GUN_CRAFTING_CATEGORY = new GunCraftingCategory(GUN_FABRICATION_RECIPE_TYPE);
    private IJeiRuntime Runtime = null;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        this.Runtime = jeiRuntime;
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{PART_CRAFTING_CATEGORY});
        registration.addRecipeCategories(new IRecipeCategory[]{GUN_CRAFTING_CATEGORY});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            registration.addRecipes(PART_FABRICATION_RECIPE_TYPE, world.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)FlansMod.PART_FABRICATION_RECIPE_TYPE.get()));
            registration.addRecipes(GUN_FABRICATION_RECIPE_TYPE, world.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)FlansMod.GUN_FABRICATION_RECIPE_TYPE.get()));
        }
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        for (ResourceLocation workbenchID : FlansMod.WORKBENCHES.getIds()) {
            WorkbenchDefinition workbenchDefinition = (WorkbenchDefinition)FlansMod.WORKBENCHES.Get(workbenchID);
            Item workbenchItem = (Item)ForgeRegistries.ITEMS.getValue(workbenchID);
            if (workbenchItem == null || !workbenchDefinition.IsValid()) continue;
            if (workbenchDefinition.partCrafting.isActive) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)workbenchItem), new RecipeType[]{PART_FABRICATION_RECIPE_TYPE});
            }
            if (!workbenchDefinition.gunCrafting.isActive) continue;
            registration.addRecipeCatalyst(new ItemStack((ItemLike)workbenchItem), new RecipeType[]{GUN_FABRICATION_RECIPE_TYPE});
        }
    }

    public void OpenPartFabList() {
        if (this.Runtime != null) {
            this.Runtime.getRecipesGui().showTypes(List.of(PART_FABRICATION_RECIPE_TYPE));
        }
    }

    public void OpenGunFabList() {
        if (this.Runtime != null) {
            this.Runtime.getRecipesGui().showTypes(List.of(GUN_FABRICATION_RECIPE_TYPE));
        }
    }
}

