/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util.shapes;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public enum VertexIndex {
    NegX_NegY_NegZ(new Direction[]{Direction.WEST, Direction.DOWN, Direction.NORTH}),
    NegX_NegY_PosZ(new Direction[]{Direction.WEST, Direction.DOWN, Direction.SOUTH}),
    NegX_PosY_NegZ(new Direction[]{Direction.WEST, Direction.UP, Direction.NORTH}),
    NegX_PosY_PosZ(new Direction[]{Direction.WEST, Direction.UP, Direction.SOUTH}),
    PosX_NegY_NegZ(new Direction[]{Direction.EAST, Direction.DOWN, Direction.NORTH}),
    PosX_NegY_PosZ(new Direction[]{Direction.EAST, Direction.DOWN, Direction.SOUTH}),
    PosX_PosY_NegZ(new Direction[]{Direction.EAST, Direction.UP, Direction.NORTH}),
    PosX_PosY_PosZ(new Direction[]{Direction.EAST, Direction.UP, Direction.SOUTH});

    private final Direction[] PossibleFaces;
    public static final VertexIndex[] UP;
    public static final VertexIndex[] DOWN;
    public static final VertexIndex[] NORTH;
    public static final VertexIndex[] EAST;
    public static final VertexIndex[] SOUTH;
    public static final VertexIndex[] WEST;

    private VertexIndex(Direction[] possibleFaces) {
        this.PossibleFaces = possibleFaces;
    }

    @Nonnull
    public Vec3 getVertex(@Nonnull AABB aabb) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NegX_NegY_NegZ -> new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_);
            case NegX_NegY_PosZ -> new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82293_);
            case NegX_PosY_NegZ -> new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82290_);
            case NegX_PosY_PosZ -> new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82293_);
            case PosX_NegY_NegZ -> new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82290_);
            case PosX_NegY_PosZ -> new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
            case PosX_PosY_NegZ -> new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82290_);
            case PosX_PosY_PosZ -> new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
        };
    }

    @Nonnull
    public static VertexIndex[] getVertexOrder(@Nonnull Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
        };
    }

    @Nonnull
    public static ImmutableList<Vec3> getAABBFace(@Nonnull AABB aabb, @Nonnull Direction dir) {
        VertexIndex[] vertexOrder;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (VertexIndex vertex : vertexOrder = VertexIndex.getVertexOrder(dir)) {
            builder.add((Object)vertex.getVertex(aabb));
        }
        return builder.build();
    }

    @Nonnull
    public static VertexIndex of(boolean positiveX, boolean positiveY, boolean positiveZ) {
        if (positiveX) {
            if (positiveY) {
                if (positiveZ) {
                    return PosX_PosY_PosZ;
                }
                return PosX_PosY_NegZ;
            }
            if (positiveZ) {
                return PosX_NegY_PosZ;
            }
            return PosX_NegY_NegZ;
        }
        if (positiveY) {
            if (positiveZ) {
                return NegX_PosY_PosZ;
            }
            return NegX_PosY_NegZ;
        }
        if (positiveZ) {
            return NegX_NegY_PosZ;
        }
        return NegX_NegY_NegZ;
    }

    @Nonnull
    public Direction[] getPossibleFaces() {
        return this.PossibleFaces;
    }

    @Nonnull
    public VertexIndex opposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NegX_NegY_NegZ -> PosX_PosY_PosZ;
            case NegX_NegY_PosZ -> PosX_PosY_NegZ;
            case NegX_PosY_NegZ -> PosX_NegY_PosZ;
            case NegX_PosY_PosZ -> PosX_NegY_NegZ;
            case PosX_NegY_NegZ -> NegX_PosY_PosZ;
            case PosX_NegY_PosZ -> NegX_PosY_NegZ;
            case PosX_PosY_NegZ -> NegX_NegY_PosZ;
            case PosX_PosY_PosZ -> NegX_NegY_NegZ;
        };
    }

    static {
        UP = new VertexIndex[]{PosX_PosY_NegZ, NegX_PosY_NegZ, NegX_PosY_PosZ, PosX_PosY_PosZ};
        DOWN = new VertexIndex[]{NegX_NegY_NegZ, PosX_NegY_NegZ, PosX_NegY_PosZ, NegX_NegY_PosZ};
        NORTH = new VertexIndex[]{NegX_PosY_NegZ, PosX_PosY_NegZ, PosX_NegY_NegZ, NegX_NegY_NegZ};
        EAST = new VertexIndex[]{PosX_PosY_NegZ, PosX_PosY_PosZ, PosX_NegY_PosZ, PosX_NegY_NegZ};
        SOUTH = new VertexIndex[]{PosX_PosY_PosZ, NegX_PosY_PosZ, NegX_NegY_PosZ, PosX_NegY_PosZ};
        WEST = new VertexIndex[]{NegX_PosY_PosZ, NegX_PosY_NegZ, NegX_NegY_NegZ, NegX_NegY_PosZ};
    }
}

