/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util.shapes;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.shapes.IPlane;
import com.flansmod.physics.common.util.shapes.IPolygon;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;

public record CollisionManifold(@Nonnull Vec3 Normal, double Distance, @Nonnull ImmutableList<Vec3> BoundingVertices) implements IPlane,
IPolygon
{
    private static final CollisionManifold INVALID = new CollisionManifold(Vec3.f_82478_, Double.MAX_VALUE, (ImmutableList<Vec3>)ImmutableList.of());

    @Nonnull
    public static CollisionManifold invalid() {
        return INVALID;
    }

    @Nonnull
    public static CollisionManifold ofLoopedVerts(@Nonnull Vec3 normal, double dist, @Nonnull ImmutableList<Vec3> verts) {
        if (((Vec3)verts.get(0)).equals(verts.get(verts.size() - 1))) {
            return new CollisionManifold(normal, dist, (ImmutableList<Vec3>)ImmutableList.copyOf((Collection)verts.subList(0, verts.size() - 1)));
        }
        return new CollisionManifold(normal, dist, verts);
    }

    @Nonnull
    public static CollisionManifold ofNonLoopedVerts(@Nonnull Vec3 normal, double dist, @Nonnull ImmutableList<Vec3> verts) {
        return new CollisionManifold(normal, dist, verts);
    }

    @Override
    @Nonnull
    public Vec3 getNormal() {
        return this.Normal;
    }

    @Override
    public double getDistance() {
        return this.Distance;
    }

    @Override
    public double project(@Nonnull Vec3 point) {
        return this.Normal.m_82526_(point);
    }

    @Override
    public double getPointHeightAbove(@Nonnull Vec3 point) {
        return this.project(point) - this.Distance;
    }

    @Override
    @Nonnull
    public Optional<Vec3> rayPlaneIntersect(@Nonnull Vec3 origin, @Nonnull Vec3 ray) {
        double rDotV = ray.m_82526_(this.Normal);
        if (Maths.approx(rDotV, 0.0)) {
            return Optional.empty();
        }
        double oDotV = origin.m_82526_(this.Normal);
        double t = (this.Distance - oDotV) / rDotV;
        return Optional.of(origin.m_82549_(ray.m_82490_(t)));
    }

    @Override
    @Nonnull
    public IPlane getFaceClipPlane() {
        return this;
    }

    @Override
    @Nonnull
    public List<Vec3> getVertices() {
        return this.BoundingVertices;
    }

    @Override
    @Nonnull
    public IPolygon clip(@Nonnull IPlane clipPlane) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.BoundingVertices.size(); ++i) {
            Optional<Vec3> clipPos;
            Vec3 vCurr = (Vec3)this.BoundingVertices.get(i);
            Vec3 vNext = this.getVertexLooped(i + 1);
            double dCurr = clipPlane.project(vCurr);
            double dNext = clipPlane.project(vNext);
            if (dCurr <= 0.0 && dNext <= 0.0) {
                builder.add((Object)vNext);
                continue;
            }
            if (dCurr > 0.0 && Maths.approx(dNext, 0.0)) {
                builder.add((Object)vNext);
                continue;
            }
            if (Maths.approx(dCurr, 0.0) && dNext > 0.0) continue;
            if (dCurr <= 0.0 && dNext > 0.0) {
                clipPos = clipPlane.rayPlaneIntersect(vCurr, vNext.m_82546_(vCurr));
                if (clipPos.isPresent()) {
                    builder.add((Object)clipPos.get());
                    continue;
                }
                FlansPhysicsMod.LOGGER.error("Clipped edge positive somehow didn't intersect");
                builder.add((Object)vNext);
                continue;
            }
            if (!(dCurr > 0.0) || !(dNext <= 0.0)) continue;
            clipPos = clipPlane.rayPlaneIntersect(vCurr, vNext.m_82546_(vCurr));
            if (clipPos.isPresent()) {
                builder.add((Object)clipPos.get());
            } else {
                FlansPhysicsMod.LOGGER.error("Clipped edge negative somehow didn't intersect");
                builder.add((Object)vNext);
            }
            builder.add((Object)vNext);
        }
        return CollisionManifold.ofLoopedVerts(this.Normal, this.Distance, (ImmutableList<Vec3>)builder.build());
    }

    @Override
    @Nonnull
    public IPolygon cullClip(@Nonnull IPlane clipPlane) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.BoundingVertices.size(); ++i) {
            Vec3 vCurr = (Vec3)this.BoundingVertices.get(i);
            double dCurr = clipPlane.project(vCurr);
            if (!(dCurr >= 0.0)) continue;
            builder.add((Object)vCurr);
        }
        return CollisionManifold.ofNonLoopedVerts(this.Normal, this.Distance, (ImmutableList<Vec3>)builder.build());
    }
}

