/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.NotImplementedException;

public class Units {

    public static enum Torque {
        KgBlocksSqPerTickSq,
        KgBlocksSqPerSecondSq;

        public static final double KgBlocksSqPerTickSq_To_KgBlocksSqPerSecondSq = 400.0;
        public static final double KgBlocksSqPerSecondSq_To_KgBlocksSqPerTickSq = 0.0025000000000000005;

        @Nonnull
        public Time TimeUnit() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case KgBlocksSqPerSecondSq -> Time.Seconds;
                case KgBlocksSqPerTickSq -> Time.Ticks;
            };
        }

        public static double Convert(double in, @Nonnull Torque from, @Nonnull Torque to) {
            in = Time.ConvertInverse(in, from.TimeUnit(), to.TimeUnit());
            in = Time.ConvertInverse(in, from.TimeUnit(), to.TimeUnit());
            return in;
        }
    }

    public static enum AngularAcceleration {
        RadiansPerTickSq,
        RadiansPerSecondSq,
        DegreesPerTickSq,
        DegreesPerSecondSq;

        public static final double RadiansPerTickSq_To_RadiansPerSecondSq = 400.0;
        public static final double RadiansPerSecondSq_To_RadiansPerTickSq = 0.0025000000000000005;

        @Nonnull
        public Angle AngleUnit() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case RadiansPerTickSq, RadiansPerSecondSq -> Angle.Radians;
                case DegreesPerTickSq, DegreesPerSecondSq -> Angle.Degrees;
            };
        }

        @Nonnull
        public Time TimeUnit() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case RadiansPerSecondSq, DegreesPerSecondSq -> Time.Seconds;
                case RadiansPerTickSq, DegreesPerTickSq -> Time.Ticks;
            };
        }

        public static double Convert(double in, @Nonnull AngularAcceleration from, @Nonnull AngularAcceleration to) {
            in = Angle.Convert(in, from.AngleUnit(), to.AngleUnit());
            in = Time.ConvertInverse(in, from.TimeUnit(), to.TimeUnit());
            in = Time.ConvertInverse(in, from.TimeUnit(), to.TimeUnit());
            return in;
        }
    }

    public static enum AngularSpeed {
        RadiansPerTick,
        RadiansPerSecond,
        DegreesPerTick,
        DegreesPerSecond;

        public static final double RadiansPerTick_To_RadiansPerSecond = 20.0;
        public static final double RadiansPerSecond_To_RadiansPerTick = 0.05;

        @Nonnull
        public Angle AngleUnit() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case RadiansPerTick, RadiansPerSecond -> Angle.Radians;
                case DegreesPerTick, DegreesPerSecond -> Angle.Degrees;
            };
        }

        @Nonnull
        public Time TimeUnit() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case RadiansPerSecond, DegreesPerSecond -> Time.Seconds;
                case RadiansPerTick, DegreesPerTick -> Time.Ticks;
            };
        }

        public static double RadiansPerTick_To_RadiansPerSecond(double in) {
            return in * 20.0;
        }

        public static double RadiansPerSecond_To_RadiansPerTick(double in) {
            return in * 0.05;
        }

        public static double DegreesPerTick_To_RadiansPerTick(double in) {
            return in * (Math.PI / 180);
        }

        public static double DegreesPerSecond_To_RadiansPerTick(double in) {
            return in * (Math.PI / 180) * 0.05;
        }

        public static double Convert(double in, @Nonnull AngularSpeed from, @Nonnull AngularSpeed to) {
            in = Angle.Convert(in, from.AngleUnit(), to.AngleUnit());
            in = Time.ConvertInverse(in, from.TimeUnit(), to.TimeUnit());
            return in;
        }
    }

    public static enum Angle {
        Radians,
        Degrees;

        public static final double Radians_To_Degrees = 57.29577951308232;
        public static final double Degrees_To_Radians = Math.PI / 180;

        public static double Radians_To_Degrees(double in) {
            return in * 57.29577951308232;
        }

        public static double Degrees_To_Radians(double in) {
            return in * (Math.PI / 180);
        }

        public static double Convert(double in, @Nonnull Angle from, @Nonnull Angle to) {
            if (from == to) {
                return in;
            }
            if (from == Radians && to == Degrees) {
                return in * 57.29577951308232;
            }
            if (from == Degrees && to == Radians) {
                return in * (Math.PI / 180);
            }
            throw new NotImplementedException();
        }
    }

    public static enum Force {
        KgBlocksPerTickSquared,
        KgBlocksPerSecondSquared;

        public static final double KgBlocksPerTickSq_To_KgBlocksPerSecondSq = 400.0;
        public static final double KgBlocksPerSecondSq_To_KgBlocksPerTickSq = 0.0025000000000000005;

        public static double KgBlocksPerTickSq_To_KgBlocksPerSecondSq(double in) {
            return in * 400.0;
        }

        public static double KgBlocksPerSecondSq_To_KgBlocksPerTickSq(double in) {
            return in * 0.0025000000000000005;
        }

        @Nonnull
        public static Vec3 KgBlocksPerTickSq_To_KgBlocksPerSecondSq(@Nonnull Vec3 in) {
            return in.m_82490_(400.0);
        }

        @Nonnull
        public static Vec3 KgBlocksPerSecondSq_To_KgBlocksPerTickSq(@Nonnull Vec3 in) {
            return in.m_82490_(0.0025000000000000005);
        }

        public static double Convert(double in, @Nonnull Force from, @Nonnull Force to) {
            if (from == to) {
                return in;
            }
            if (from == KgBlocksPerSecondSquared && to == KgBlocksPerTickSquared) {
                return in * 0.0025000000000000005;
            }
            if (from == KgBlocksPerTickSquared && to == KgBlocksPerSecondSquared) {
                return in * 400.0;
            }
            throw new NotImplementedException();
        }

        @Nonnull
        public static Vec3 Convert(@Nonnull Vec3 in, @Nonnull Force from, @Nonnull Force to) {
            if (from == to) {
                return in;
            }
            if (from == KgBlocksPerSecondSquared && to == KgBlocksPerTickSquared) {
                return in.m_82490_(0.0025000000000000005);
            }
            if (from == KgBlocksPerTickSquared && to == KgBlocksPerSecondSquared) {
                return in.m_82490_(400.0);
            }
            throw new NotImplementedException();
        }
    }

    public static enum Acceleration {
        BlocksPerTickSquared,
        BlocksPerSecondSquared;

        public static final double BlocksPerTickSq_To_BlocksPerSecondSq = 400.0;
        public static final double BlocksPerSecondSq_To_BlocksPerTickSq = 0.0025000000000000005;

        public static double BlocksPerTickSq_To_BlocksPerSecondSq(double in) {
            return in * 400.0;
        }

        public static double BlocksPerSecondSq_To_BlocksPerTickSq(double in) {
            return in * 0.0025000000000000005;
        }

        @Nonnull
        public static Vec3 BlocksPerTickSq_To_BlocksPerSecondSq(@Nonnull Vec3 in) {
            return in.m_82490_(400.0);
        }

        @Nonnull
        public static Vec3 BlocksPerSecondSq_To_BlocksPerTickSq(@Nonnull Vec3 in) {
            return in.m_82490_(0.0025000000000000005);
        }

        public static double Convert(double in, @Nonnull Acceleration from, @Nonnull Acceleration to) {
            if (from == to) {
                return in;
            }
            if (from == BlocksPerSecondSquared && to == BlocksPerTickSquared) {
                return in * 0.0025000000000000005;
            }
            if (from == BlocksPerTickSquared && to == BlocksPerSecondSquared) {
                return in * 400.0;
            }
            throw new NotImplementedException();
        }

        @Nonnull
        public static Vec3 Convert(@Nonnull Vec3 in, @Nonnull Acceleration from, @Nonnull Acceleration to) {
            if (from == to) {
                return in;
            }
            if (from == BlocksPerSecondSquared && to == BlocksPerTickSquared) {
                return in.m_82490_(0.0025000000000000005);
            }
            if (from == BlocksPerTickSquared && to == BlocksPerSecondSquared) {
                return in.m_82490_(400.0);
            }
            throw new NotImplementedException();
        }
    }

    public static enum Speed {
        BlocksPerTick,
        BlocksPerSecond;

        public static final double BlocksPerTick_To_BlocksPerSecond = 20.0;
        public static final double BlocksPerSecond_To_BlocksPerTick = 0.05;

        public static double BlocksPerTick_To_BlocksPerSecond(double in) {
            return in * 20.0;
        }

        public static double BlocksPerSecond_To_BlocksPerTick(double in) {
            return in * 0.05;
        }

        @Nonnull
        public static Vec3 BlocksPerTick_To_BlocksPerSecond(@Nonnull Vec3 in) {
            return in.m_82490_(20.0);
        }

        @Nonnull
        public static Vec3 BlocksPerSecond_To_BlocksPerTick(@Nonnull Vec3 in) {
            return in.m_82490_(0.05);
        }

        public static double Convert(double in, @Nonnull Speed from, @Nonnull Speed to) {
            if (from == to) {
                return in;
            }
            if (from == BlocksPerSecond && to == BlocksPerTick) {
                return in * 0.05;
            }
            if (from == BlocksPerTick && to == BlocksPerSecond) {
                return in * 20.0;
            }
            throw new NotImplementedException();
        }

        @Nonnull
        public static Vec3 Convert(@Nonnull Vec3 in, @Nonnull Speed from, @Nonnull Speed to) {
            if (from == to) {
                return in;
            }
            if (from == BlocksPerSecond && to == BlocksPerTick) {
                return in.m_82490_(0.05);
            }
            if (from == BlocksPerTick && to == BlocksPerSecond) {
                return in.m_82490_(20.0);
            }
            throw new NotImplementedException();
        }
    }

    public static enum Distance {
        Blocks;

    }

    public static enum Time {
        Ticks,
        Seconds;

        public static final double Ticks_To_Seconds = 0.05;
        public static final double Seconds_To_Ticks = 20.0;
        public static final double PerTick_To_PerSecond = 20.0;
        public static final double PerSecond_To_PerTick = 0.05;
        public static final double PerTickSq_To_PerSecondSq = 400.0;
        public static final double PerSecondSq_To_PerTickSq = 0.0025000000000000005;

        public static double Convert(double in, @Nonnull Time from, @Nonnull Time to) {
            if (from == to) {
                return in;
            }
            if (from == Ticks && to == Seconds) {
                return in * 0.05;
            }
            if (from == Seconds && to == Ticks) {
                return in * 20.0;
            }
            throw new NotImplementedException();
        }

        public static double ConvertInverse(double in, @Nonnull Time from, @Nonnull Time to) {
            return Time.Convert(in, to, from);
        }
    }
}

