/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.tests;

import com.flansmod.physics.common.entity.CenteredEntityDimensions;
import com.flansmod.physics.common.entity.PhysicsComponent;
import com.flansmod.physics.common.entity.PhysicsEntity;
import com.flansmod.physics.common.units.LinearForce;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TestCubeEntity
extends PhysicsEntity {
    public float Mass = 1.0f;
    public Vec3 MomentOfInertia = new Vec3(1.0, 1.0, 1.0);

    public TestCubeEntity(@Nonnull EntityType<? extends Entity> type, @Nonnull Level world) {
        super(type, world);
        this.m_6210_();
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose pose) {
        return CenteredEntityDimensions.fixed(1.0f, 1.0f);
    }

    @Override
    protected void initPhysics() {
        this.addPhysicsComponent(CORE_PHYSICS, this.getEntityRootAsTransform(), List.of(new AABB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5)), 1.0);
    }

    @Override
    protected void tickPhysics() {
        PhysicsComponent coreComponent = this.getRootComponent();
        LinearForce coreGravity = LinearForce.kgBlocksPerSecondSq(new Vec3(0.0, (double)(-9.81f * this.Mass), 0.0));
        coreComponent.getPendingForces().addForce(coreGravity);
        coreComponent.getPendingForces().addDampener(0.1f);
    }

    @Override
    protected void tickOutsidePhysicsRange() {
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }
}

