/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.tests;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.threading.CollisionTasks;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.ProjectedRange;
import com.flansmod.physics.common.util.ProjectionUtil;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CollisionTests {
    public static void runTests() {
        Vec3 xAxis = new Vec3(1.0, 0.0, 0.0);
        Vec3 yAxis = new Vec3(0.0, 1.0, 0.0);
        Vec3 zAxis = new Vec3(0.0, 0.0, 1.0);
        AABB unitCube = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        AABB collidingCube = new AABB(0.25, 0.25, 0.25, 1.25, 1.25, 1.25);
        AABB collidingOnlyZCube = new AABB(-2.0, -2.0, 0.5, -1.0, -1.0, 1.5);
        AABB nonCollidingCube = new AABB(2.0, 2.0, 2.0, 3.0, 3.0, 3.0);
        CollisionTests.assertEqual(ProjectionUtil.ProjectAABBMinMax(xAxis, unitCube), 0.0, 1.0, "UnitCube projection x");
        CollisionTests.assertEqual(ProjectionUtil.ProjectAABBMinMax(yAxis, unitCube), 0.0, 1.0, "UnitCube projection y");
        CollisionTests.assertEqual(ProjectionUtil.ProjectAABBMinMax(zAxis, unitCube), 0.0, 1.0, "UnitCube projection z");
        CollisionTests.assertEqual(ProjectionUtil.ProjectAABBMinMax(xAxis.m_82490_(-1.0), unitCube), -1.0, 0.0, "UnitCube projection -x");
        CollisionTests.assertEqual(ProjectionUtil.ProjectAABBMinMax(yAxis.m_82490_(-1.0), unitCube), -1.0, 0.0, "UnitCube projection -y");
        CollisionTests.assertEqual(ProjectionUtil.ProjectAABBMinMax(zAxis.m_82490_(-1.0), unitCube), -1.0, 0.0, "UnitCube projection -z");
        CollisionTests.assertCollidesOnAxis(xAxis, unitCube, collidingCube, "Colliding cube did not collide in x");
        CollisionTests.assertCollidesOnAxis(yAxis, unitCube, collidingCube, "Colliding cube did not collide in y");
        CollisionTests.assertCollidesOnAxis(zAxis, unitCube, collidingCube, "Colliding cube did not collide in z");
        CollisionTests.assertSeparatesOnAxis(xAxis, unitCube, collidingOnlyZCube, "Colliding only in Z cube did collide in x");
        CollisionTests.assertSeparatesOnAxis(yAxis, unitCube, collidingOnlyZCube, "Colliding only in Z cube did collide in y");
        CollisionTests.assertCollidesOnAxis(zAxis, unitCube, collidingOnlyZCube, "Colliding only in Z cube did not collide in z");
        CollisionTests.assertCollides(unitCube, collidingCube, "Colliding cube did not collide");
        CollisionTests.assertSeparated(unitCube, collidingOnlyZCube, "Z-overlap non-colliding cube collided");
        CollisionTests.assertSeparated(unitCube, nonCollidingCube, "Non colliding cube collided");
    }

    private static void assertCollidesOnAxis(@Nonnull Vec3 axis, @Nonnull AABB a, @Nonnull AABB b, @Nonnull String error) {
        CollisionTests.assertCollides(ProjectionUtil.ProjectAABBMinMax(axis, a), ProjectionUtil.ProjectAABBMinMax(axis, b), error);
    }

    private static void assertSeparatesOnAxis(@Nonnull Vec3 axis, @Nonnull AABB a, @Nonnull AABB b, @Nonnull String error) {
        CollisionTests.assertNotCollides(ProjectionUtil.ProjectAABBMinMax(axis, a), ProjectionUtil.ProjectAABBMinMax(axis, b), error);
    }

    private static void assertCollides(@Nonnull ProjectedRange a, @Nonnull ProjectedRange b, @Nonnull String error) {
        if (ProjectionUtil.Separated(a, b)) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertNotCollides(@Nonnull ProjectedRange a, @Nonnull ProjectedRange b, @Nonnull String error) {
        if (!ProjectionUtil.Separated(a, b)) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertEqual(@Nonnull ProjectedRange range, double min, double max, @Nonnull String error) {
        if (!Maths.approx(range.min(), min) || !Maths.approx(range.max(), max)) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertCollides(@Nonnull AABB a, @Nonnull AABB b, @Nonnull String error) {
        if (CollisionTasks.separate(a, b).success()) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertCollides(@Nonnull TransformedBB a, @Nonnull AABB b, @Nonnull String error) {
        if (CollisionTasks.separate(a, b).success()) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertCollides(@Nonnull TransformedBB a, @Nonnull TransformedBB b, @Nonnull String error) {
        if (CollisionTasks.separate(a, b).success()) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertSeparated(@Nonnull AABB a, @Nonnull AABB b, @Nonnull String error) {
        if (!CollisionTasks.separate(a, b).success()) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertSeparated(@Nonnull TransformedBB a, @Nonnull AABB b, @Nonnull String error) {
        if (!CollisionTasks.separate(a, b).success()) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertSeparated(@Nonnull TransformedBB a, @Nonnull TransformedBB b, @Nonnull String error) {
        if (!CollisionTasks.separate(a, b).success()) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }
}

