/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision.obb;

import com.flansmod.physics.common.collision.DynamicCollisionEvent;
import com.flansmod.physics.common.collision.StaticCollisionEvent;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.TransformedBBCollection;
import com.flansmod.physics.common.collision.obb.ICollisionAccessDynamicObject;
import com.flansmod.physics.common.collision.obb.IConstDynamicObject;
import com.flansmod.physics.common.collision.obb.IEditAccessDynamicObject;
import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class DynamicObject
implements IConstDynamicObject,
ICollisionAccessDynamicObject,
IEditAccessDynamicObject {
    public static final int KILL_VOLUME_NEGATIVE_Y = -256;
    public static final int KILL_VOLUME_POSITIVE_Y = Short.MAX_VALUE;
    public static final Vec3 DEFAULT_MOMENT_OF_INERTIA = new Vec3(1.0, 1.0, 1.0);
    public static final Vec3 DEFAULT_INERTIA_TENSOR = new Vec3(1.0, 1.0, 1.0);
    public final ImmutableList<AABB> Colliders;
    public final AABB LocalBounds;
    public final double Mass;
    public final double InverseMass;
    public final Vec3 MomentOfInertia;
    public final Vec3 InertiaTensor;
    public final double LinearDrag;
    public final double AngularDrag;
    private FrameData CurrentFrame;
    private FrameData PendingFrame;
    private boolean teleportedPendingFrame = false;
    public final List<DynamicCollisionEvent> DynamicCollisions;
    public final List<StaticCollisionEvent> StaticCollisions;

    private DynamicObject(@Nonnull List<AABB> localColliders, @Nonnull Transform initialLocation, double mass, double invMass, double linearDrag, double angularDrag, @Nonnull Vec3 momentOfInertia, @Nonnull Vec3 inertiaTensor) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.Colliders = builder.addAll(localColliders).build();
        this.LocalBounds = this.getLocalBounds();
        this.CurrentFrame = new FrameData(Transform.copy(initialLocation), LinearVelocity.Zero, AngularVelocity.Zero);
        this.PendingFrame = null;
        this.DynamicCollisions = new ArrayList<DynamicCollisionEvent>();
        this.StaticCollisions = new ArrayList<StaticCollisionEvent>();
        this.Mass = mass;
        this.InverseMass = invMass;
        this.MomentOfInertia = momentOfInertia;
        this.InertiaTensor = inertiaTensor;
        this.LinearDrag = linearDrag;
        this.AngularDrag = angularDrag;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public void preTick() {
        this.StaticCollisions.clear();
        this.DynamicCollisions.clear();
        this.extrapolatePendingFrame();
    }

    @Override
    public boolean isInvalid() {
        if (this.PendingFrame != null) {
            if (this.PendingFrame.Location.hasNaN()) {
                return true;
            }
            Vec3 pos = this.PendingFrame.Location.positionVec3();
            if (pos.f_82480_ < -256.0 || pos.f_82480_ > 32767.0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public double getMass() {
        return this.Mass;
    }

    @Override
    public double getInverseMass() {
        return this.InverseMass;
    }

    @Override
    @Nonnull
    public Vec3 getMomentOfInertia() {
        return this.MomentOfInertia;
    }

    @Override
    @Nonnull
    public Vec3 getInertiaTensor() {
        return this.InertiaTensor;
    }

    @Override
    public double getLinearDrag() {
        return this.LinearDrag;
    }

    @Override
    public double getAngularDrag() {
        return this.AngularDrag;
    }

    @Override
    @Nonnull
    public AABB getCurrentWorldBounds() {
        return this.CurrentFrame.Location.localToGlobalBounds(this.getLocalBounds());
    }

    @Override
    @Nonnull
    public AABB getPendingWorldBounds() {
        FrameData frame = this.PendingFrame;
        return frame.Location.localToGlobalBounds(this.getLocalBounds());
    }

    @Override
    @Nonnull
    public AABB getSweepTestAABB() {
        AABB globalAABB = this.CurrentFrame.Location.localToGlobalBounds(this.getLocalBounds());
        return globalAABB.m_82369_(this.CurrentFrame.linearVelocity.applyOneTick()).m_82400_(this.LocalBounds.m_82309_());
    }

    @Override
    @Nonnull
    public AABB getLocalBounds() {
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double zMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMax = -1.7976931348623157E308;
        double zMax = -1.7976931348623157E308;
        for (AABB aabb : this.Colliders) {
            xMax = Maths.max(aabb.f_82291_, xMax);
            yMax = Maths.max(aabb.f_82292_, yMax);
            zMax = Maths.max(aabb.f_82293_, zMax);
            xMin = Maths.min(aabb.f_82288_, xMin);
            yMin = Maths.min(aabb.f_82289_, yMin);
            zMin = Maths.min(aabb.f_82290_, zMin);
        }
        return new AABB(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    @Override
    @Nonnull
    public TransformedBBCollection getCurrentColliders() {
        return new TransformedBBCollection(this.CurrentFrame.Location, this.Colliders);
    }

    @Override
    @Nonnull
    public TransformedBB getCurrentBB() {
        return TransformedBB.Of(this.CurrentFrame.Location, this.LocalBounds);
    }

    @Override
    @Nonnull
    public Transform getCurrentLocation() {
        return this.CurrentFrame.Location;
    }

    @Override
    @Nonnull
    public LinearVelocity getLinearVelocity() {
        return this.CurrentFrame.linearVelocity;
    }

    @Override
    @Nonnull
    public AngularVelocity getAngularVelocity() {
        return this.CurrentFrame.angularVelocity;
    }

    @Override
    public void setLinearVelocity(@Nonnull LinearVelocity linearVelocity) {
        this.CurrentFrame = new FrameData(this.CurrentFrame.Location, linearVelocity, this.CurrentFrame.angularVelocity);
    }

    @Override
    public void addLinearAcceleration(@Nonnull LinearAcceleration linearAcceleration) {
        this.CurrentFrame = new FrameData(this.CurrentFrame.Location, this.CurrentFrame.linearVelocity.add(linearAcceleration.applyOneTick()), this.CurrentFrame.angularVelocity);
    }

    @Override
    public void setAngularVelocity(@Nonnull AngularVelocity angularVelocity) {
        this.CurrentFrame = new FrameData(this.CurrentFrame.Location, this.CurrentFrame.linearVelocity, angularVelocity);
    }

    @Override
    public void addAngularAcceleration(@Nonnull AngularAcceleration angularAcceleration) {
        this.CurrentFrame = new FrameData(this.CurrentFrame.Location, this.CurrentFrame.linearVelocity, this.CurrentFrame.angularVelocity.compose(angularAcceleration.applyOneTick()));
    }

    @Override
    public void teleportTo(@Nonnull Transform location) {
        this.CurrentFrame = new FrameData(location, this.CurrentFrame.linearVelocity, this.CurrentFrame.angularVelocity);
        this.teleportedPendingFrame = true;
    }

    @Override
    public boolean isPendingFrameEvaluated() {
        return this.PendingFrame != null;
    }

    @Override
    @Nonnull
    public TransformedBBCollection getPendingColliders() {
        if (this.PendingFrame != null) {
            return new TransformedBBCollection(this.PendingFrame.Location, this.Colliders);
        }
        return this.getCurrentColliders();
    }

    @Override
    @Nonnull
    public TransformedBB getPendingBB() {
        if (this.PendingFrame != null) {
            return TransformedBB.Of(this.PendingFrame.Location, this.LocalBounds);
        }
        return this.getCurrentBB();
    }

    @Override
    @Nonnull
    public Transform getPendingLocation() {
        if (this.PendingFrame != null) {
            return this.PendingFrame.Location;
        }
        return this.getCurrentLocation();
    }

    @Override
    public void extrapolatePendingFrame(double parametricTicks) {
        LinearVelocity linearV = this.CurrentFrame.linearVelocity.scale(this.getLinearDecayPerTick());
        AngularVelocity angularV = this.CurrentFrame.angularVelocity.scale(this.getAngularDecayPerTick());
        Vec3 deltaPos = linearV.applyOverTicks(parametricTicks);
        Quaternionf deltaRot = angularV.applyOverTicks(parametricTicks);
        Transform newLoc = Transform.fromPosAndQuat(this.CurrentFrame.Location.positionVec3().m_82549_(deltaPos), this.CurrentFrame.Location.Orientation.mul((Quaternionfc)deltaRot, new Quaternionf()));
        this.PendingFrame = new FrameData(newLoc, linearV, angularV);
    }

    @Override
    public void setPendingLocation(@Nonnull Transform location) {
        if (this.PendingFrame == null) {
            this.extrapolatePendingFrame();
        }
        this.PendingFrame = new FrameData(location, this.PendingFrame.linearVelocity, this.PendingFrame.angularVelocity);
    }

    @Override
    public void setPendingLinearVelocity(@Nonnull LinearVelocity linearVelocity) {
        if (this.PendingFrame == null) {
            this.extrapolatePendingFrame();
        }
        this.PendingFrame = new FrameData(this.PendingFrame.Location, linearVelocity, this.PendingFrame.angularVelocity);
    }

    @Override
    public void setPendingAngularVelocity(@Nonnull AngularVelocity angularVelocity) {
        if (this.PendingFrame == null) {
            this.extrapolatePendingFrame();
        }
        this.PendingFrame = new FrameData(this.PendingFrame.Location, this.PendingFrame.linearVelocity, angularVelocity);
    }

    @Override
    public void commitPendingFrame() {
        this.CurrentFrame = this.PendingFrame;
        this.PendingFrame = null;
        this.teleportedPendingFrame = false;
    }

    @Override
    public void discardPendingFrame() {
        this.PendingFrame = null;
        this.teleportedPendingFrame = false;
    }

    @Override
    public boolean pendingFrameIsTeleport() {
        return this.teleportedPendingFrame;
    }

    private record FrameData(@Nonnull Transform Location, @Nonnull LinearVelocity linearVelocity, @Nonnull AngularVelocity angularVelocity) {
    }

    public static class Builder {
        private ImmutableList.Builder<AABB> localColliders = new ImmutableList.Builder();
        private double mass = 1.0;
        private double invMass = 1.0;
        private Vec3 momentOfInertia = null;
        private Vec3 inertiaTensor = null;
        private double linearDrag = 0.0;
        private double angularDrag = 0.0;
        private Transform initialLocation = null;

        @Nonnull
        public Builder withMass(double kg) {
            if (Maths.approx(kg, 0.0)) {
                return this.massless();
            }
            this.mass = kg;
            this.invMass = 1.0 / kg;
            return this;
        }

        @Nonnull
        public Builder withInverseMass(double oneOverKg) {
            if (Maths.approx(oneOverKg, 0.0)) {
                return this.immovable();
            }
            this.mass = 1.0 / oneOverKg;
            this.invMass = oneOverKg;
            return this;
        }

        @Nonnull
        public Builder massless() {
            this.mass = 0.0;
            this.invMass = Double.MAX_VALUE;
            return this;
        }

        @Nonnull
        public Builder immovable() {
            this.mass = Double.MAX_VALUE;
            this.invMass = 0.0;
            return this;
        }

        @Nonnull
        public Builder withDrag(double decayPerTick) {
            this.linearDrag = decayPerTick;
            this.angularDrag = decayPerTick;
            return this;
        }

        @Nonnull
        public Builder withLinearDrag(double decayPerTick) {
            this.linearDrag = decayPerTick;
            return this;
        }

        @Nonnull
        public Builder withAngularDrag(double decayPerTick) {
            this.angularDrag = decayPerTick;
            return this;
        }

        @Nonnull
        public Builder withMomentOfInertia(@Nonnull Vec3 moment) {
            if (Maths.approx(moment, Vec3.f_82478_)) {
                return this.zeroInertia();
            }
            this.momentOfInertia = moment;
            this.inertiaTensor = new Vec3(1.0 / moment.f_82479_, 1.0 / moment.f_82480_, 1.0 / moment.f_82481_);
            return this;
        }

        @Nonnull
        public Builder withInertiaTensor(@Nonnull Vec3 tensor) {
            if (Maths.approx(tensor, Vec3.f_82478_)) {
                return this.infiniteInertia();
            }
            this.momentOfInertia = new Vec3(1.0 / tensor.f_82479_, 1.0 / tensor.f_82480_, 1.0 / tensor.f_82481_);
            this.inertiaTensor = tensor;
            return this;
        }

        @Nonnull
        public Builder infiniteInertia() {
            this.momentOfInertia = new Vec3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            this.inertiaTensor = Vec3.f_82478_;
            return this;
        }

        @Nonnull
        public Builder zeroInertia() {
            this.momentOfInertia = Vec3.f_82478_;
            this.inertiaTensor = new Vec3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            return this;
        }

        @Nonnull
        public Builder inLocation(@Nonnull Transform loc) {
            this.initialLocation = loc;
            return this;
        }

        @Nonnull
        public Builder withCollider(@Nonnull AABB collider) {
            this.localColliders.add((Object)collider);
            return this;
        }

        @Nonnull
        public Builder withColliders(@Nonnull Iterable<AABB> colliders) {
            this.localColliders.addAll(colliders);
            return this;
        }

        @Nonnull
        public DynamicObject build() {
            return new DynamicObject((List<AABB>)this.localColliders.build(), this.initialLocation != null ? this.initialLocation : Transform.IDENTITY, this.mass, this.invMass, this.linearDrag, this.angularDrag, this.momentOfInertia != null ? this.momentOfInertia : DEFAULT_MOMENT_OF_INERTIA, this.inertiaTensor != null ? this.inertiaTensor : DEFAULT_INERTIA_TENSOR);
        }
    }
}

