/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision;

import com.flansmod.physics.common.deprecated.ContinuousCollisionUtility;
import com.flansmod.physics.common.deprecated.ContinuousSeparationManifold;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.shapes.IPolygon;
import com.flansmod.physics.common.util.shapes.Polygon;
import com.flansmod.physics.common.util.shapes.VertexIndex;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public record TransformedBB(@Nonnull Transform Loc, @Nonnull Vector3f HalfExtents) {
    @Nonnull
    public static TransformedBB EntityInSpace(@Nonnull AABB entityBounds, @Nonnull Vec3 entityPos, @Nonnull Transform space) {
        return new TransformedBB(space.globalToLocalTransform(Transform.fromPos(entityPos)), new Vector3f((float)entityBounds.m_82362_() / 2.0f, (float)entityBounds.m_82376_() / 2.0f, (float)entityBounds.m_82385_() / 2.0f));
    }

    @Nonnull
    public static TransformedBB Of(@Nonnull Transform location, @Nonnull AABB aabb) {
        Transform centerLoc = Transform.compose(location, Transform.fromPos(aabb.m_82399_()));
        return new TransformedBB(centerLoc, new Vector3f((float)aabb.m_82362_() / 2.0f, (float)aabb.m_82376_() / 2.0f, (float)aabb.m_82385_() / 2.0f));
    }

    @Nonnull
    public static TransformedBB Of(@Nonnull AABB aabb) {
        return new TransformedBB(Transform.fromPos(aabb.m_82399_()), new Vector3f((float)aabb.m_82362_() / 2.0f, (float)aabb.m_82376_() / 2.0f, (float)aabb.m_82385_() / 2.0f));
    }

    @Nullable
    public ContinuousSeparationManifold Intersect(@Nonnull AABB bb, @Nonnull Vec3 motion) {
        return ContinuousCollisionUtility.SeparateContinuous(this, motion, bb);
    }

    public boolean Contains(@Nonnull Vec3 point) {
        Vec3 local = this.Loc.globalToLocalPosition(point);
        return Maths.abs(local.f_82479_) <= (double)this.HalfExtents.x && Maths.abs(local.f_82480_) <= (double)this.HalfExtents.y && Maths.abs(local.f_82481_) <= (double)this.HalfExtents.z;
    }

    public boolean ApproxContains(@Nonnull Vec3 point) {
        return this.ApproxContains(point, 0.01);
    }

    public boolean ApproxContains(@Nonnull Vec3 point, double epsilon) {
        Vec3 local = this.Loc.globalToLocalPosition(point);
        return Maths.abs(local.f_82479_) <= (double)this.HalfExtents.x + epsilon && Maths.abs(local.f_82480_) <= (double)this.HalfExtents.y + epsilon && Maths.abs(local.f_82481_) <= (double)this.HalfExtents.z + epsilon;
    }

    public double XSize() {
        return (double)this.HalfExtents.x * 2.0;
    }

    public double YSize() {
        return (double)this.HalfExtents.y * 2.0;
    }

    public double ZSize() {
        return (double)this.HalfExtents.z * 2.0;
    }

    public double GetMaxRadiusBound() {
        return (double)Maths.max(this.HalfExtents.x, this.HalfExtents.y, this.HalfExtents.z) * Maths.Root2;
    }

    @Nonnull
    public TransformedBB Move(@Nonnull Function<Transform, Transform> func) {
        return new TransformedBB(func.apply(this.Loc), this.HalfExtents);
    }

    @Nonnull
    public Vec3 GetCenter() {
        return this.Loc.positionVec3();
    }

    @Nonnull
    public Vec3 GetCorner(@Nonnull VertexIndex corner) {
        return switch (corner) {
            default -> throw new IncompatibleClassChangeError();
            case VertexIndex.NegX_NegY_NegZ -> this.Loc.localToGlobalPosition(new Vec3((double)(-this.HalfExtents.x), (double)(-this.HalfExtents.y), (double)(-this.HalfExtents.z)));
            case VertexIndex.NegX_NegY_PosZ -> this.Loc.localToGlobalPosition(new Vec3((double)(-this.HalfExtents.x), (double)(-this.HalfExtents.y), (double)this.HalfExtents.z));
            case VertexIndex.NegX_PosY_NegZ -> this.Loc.localToGlobalPosition(new Vec3((double)(-this.HalfExtents.x), (double)this.HalfExtents.y, (double)(-this.HalfExtents.z)));
            case VertexIndex.NegX_PosY_PosZ -> this.Loc.localToGlobalPosition(new Vec3((double)(-this.HalfExtents.x), (double)this.HalfExtents.y, (double)this.HalfExtents.z));
            case VertexIndex.PosX_NegY_NegZ -> this.Loc.localToGlobalPosition(new Vec3((double)this.HalfExtents.x, (double)(-this.HalfExtents.y), (double)(-this.HalfExtents.z)));
            case VertexIndex.PosX_NegY_PosZ -> this.Loc.localToGlobalPosition(new Vec3((double)this.HalfExtents.x, (double)(-this.HalfExtents.y), (double)this.HalfExtents.z));
            case VertexIndex.PosX_PosY_NegZ -> this.Loc.localToGlobalPosition(new Vec3((double)this.HalfExtents.x, (double)this.HalfExtents.y, (double)(-this.HalfExtents.z)));
            case VertexIndex.PosX_PosY_PosZ -> this.Loc.localToGlobalPosition(new Vec3((double)this.HalfExtents.x, (double)this.HalfExtents.y, (double)this.HalfExtents.z));
        };
    }

    @Nonnull
    public Vec3 GetAxis(@Nonnull Direction dir) {
        return this.Loc.directionVec(dir);
    }

    @Nonnull
    public IPolygon GetFace(@Nonnull Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Polygon.square(this.GetCorner(VertexIndex.UP[0]), this.GetCorner(VertexIndex.UP[1]), this.GetCorner(VertexIndex.UP[2]), this.GetCorner(VertexIndex.UP[3]));
            case Direction.DOWN -> Polygon.square(this.GetCorner(VertexIndex.DOWN[0]), this.GetCorner(VertexIndex.DOWN[1]), this.GetCorner(VertexIndex.DOWN[2]), this.GetCorner(VertexIndex.DOWN[3]));
            case Direction.NORTH -> Polygon.square(this.GetCorner(VertexIndex.NORTH[0]), this.GetCorner(VertexIndex.NORTH[1]), this.GetCorner(VertexIndex.NORTH[2]), this.GetCorner(VertexIndex.NORTH[3]));
            case Direction.EAST -> Polygon.square(this.GetCorner(VertexIndex.EAST[0]), this.GetCorner(VertexIndex.EAST[1]), this.GetCorner(VertexIndex.EAST[2]), this.GetCorner(VertexIndex.EAST[3]));
            case Direction.SOUTH -> Polygon.square(this.GetCorner(VertexIndex.SOUTH[0]), this.GetCorner(VertexIndex.SOUTH[1]), this.GetCorner(VertexIndex.SOUTH[2]), this.GetCorner(VertexIndex.SOUTH[3]));
            case Direction.WEST -> Polygon.square(this.GetCorner(VertexIndex.WEST[0]), this.GetCorner(VertexIndex.WEST[1]), this.GetCorner(VertexIndex.WEST[2]), this.GetCorner(VertexIndex.WEST[3]));
        };
    }
}

